/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.users;

import com.atlassian.bitbucket.pageobjects.element.ConfirmDialog;
import com.atlassian.bitbucket.pageobjects.element.Flag;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.admin.UserAddPage;
import com.atlassian.webdriver.bitbucket.page.admin.UserAnonymizePage;
import com.atlassian.webdriver.bitbucket.page.admin.users.DirectorySelector;
import com.atlassian.webdriver.bitbucket.page.admin.users.LastActiveSelector;
import com.atlassian.webdriver.bitbucket.page.admin.users.LicenseStatusSelector;
import com.atlassian.webdriver.bitbucket.page.admin.users.UserTableRow;
import com.atlassian.webdriver.bitbucket.util.Locators;
import java.util.List;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class UserTablePage
extends BitbucketPage {
    @ElementBy(cssSelector="[data-testid='create-user']")
    private PageElement buttonToAddUser;
    @ElementBy(cssSelector="[data-testid='export-users-all-button']")
    private PageElement buttonToExportAllUsers;
    @ElementBy(cssSelector="[data-testid='export-users-filtered-button']")
    private PageElement buttonToExportFilteredUsers;
    @ElementBy(cssSelector="[data-testid='export-users-permissions-button']")
    private PageElement buttonToExportUserPermissions;
    @ElementBy(cssSelector="[data-testid='confirm-action-modal']")
    private PageElement exportDialog;
    @ElementBy(cssSelector="[data-testid='export-users--trigger']")
    private PageElement exportDropdown;
    @ElementBy(className="directory-select")
    private PageElement filterForDirectory;
    @ElementBy(className="user-last-active-filter")
    private PageElement filterForLastActive;
    @ElementBy(className="license-status-select")
    private PageElement filterForLicenseStatus;
    @ElementBy(id="search-filter")
    private PageElement filterForSearch;
    @ElementBy(className="user-table-empty-state")
    private PageElement noUsersTable;
    @ElementBy(cssSelector="[data-testid='anonymise-user']")
    private PageElement userAnonymizeOption;
    @ElementBy(className="paged-table")
    private PageElement usersTable;
    @ElementBy(cssSelector="[data-testid='more-options-users']")
    private PageElement usersTableListMoreButton;

    public void clearTextInSearchBox() {
        this.filterForSearch.clear();
    }

    public UserAnonymizePage clickAnonymize() {
        this.usersTableListMoreButton.click();
        Poller.waitUntilTrue((TimedQuery)this.userAnonymizeOption.timed().isVisible());
        this.userAnonymizeOption.click();
        return (UserAnonymizePage)this.pageBinder.bind(UserAnonymizePage.class, new Object[0]);
    }

    public UserAddPage clickCreateUser() {
        this.buttonToAddUser.click();
        return (UserAddPage)this.pageBinder.bind(UserAddPage.class, new Object[0]);
    }

    public void enterTextInSearchBox(String text) {
        Poller.waitUntilTrue((TimedQuery)this.filterForSearch.timed().isVisible());
        this.filterForSearch.clear().type(new CharSequence[]{text});
    }

    public ConfirmDialog exportUserPermissions() {
        this.exportDropdown.click();
        Poller.waitUntilTrue((TimedQuery)this.buttonToExportUserPermissions.timed().isVisible());
        this.buttonToExportUserPermissions.click();
        return (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.exportDialog});
    }

    public ConfirmDialog exportUsers() {
        this.exportDropdown.click();
        Poller.waitUntilTrue((TimedQuery)this.buttonToExportAllUsers.timed().isVisible());
        this.buttonToExportAllUsers.click();
        return (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.exportDialog});
    }

    public ConfirmDialog exportUsersFiltered() {
        this.exportDropdown.click();
        Poller.waitUntilTrue((TimedQuery)this.buttonToExportFilteredUsers.timed().isVisible());
        this.buttonToExportFilteredUsers.click();
        return (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.exportDialog});
    }

    public TimedQuery<List<Flag>> getAllFlags() {
        return Queries.forSupplier((Timeouts)this.timeouts, this::getFlags);
    }

    public DirectorySelector getDirectorySelector() {
        return (DirectorySelector)this.pageBinder.bind(DirectorySelector.class, new Object[]{this.filterForDirectory});
    }

    public LastActiveSelector getLastActiveSelector() {
        PageElement selector = this.filterForLastActive.click();
        return (LastActiveSelector)this.pageBinder.bind(LastActiveSelector.class, new Object[]{selector});
    }

    public LicenseStatusSelector getLicenseStatusSelector() {
        return (LicenseStatusSelector)this.pageBinder.bind(LicenseStatusSelector.class, new Object[]{this.filterForLicenseStatus});
    }

    public String getUrl() {
        return "/admin/users";
    }

    public UserTableRow getUserByIndex(int index) {
        return (UserTableRow)((List)Poller.waitUntil(this.getUsers(), (Matcher)Matchers.not((Matcher)Matchers.empty()))).get(index);
    }

    public UserTableRow getUserRowByUsername(String username) {
        return ((List)Poller.waitUntil(this.getUsers(), (Matcher)Matchers.hasItem(this.username((Matcher<String>)Matchers.equalTo((Object)username))))).stream().filter(row -> ((String)row.getUsername().now()).equals(username)).findFirst().get();
    }

    public TimedQuery<List<UserTableRow>> getUsers() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> (List)this.usersTable.findAll(Locators.tableRow()).stream().map(e -> (UserTableRow)this.pageBinder.bind(UserTableRow.class, new Object[]{e})).collect(MoreCollectors.toImmutableList()));
    }

    public TimedCondition hasNoMatchingUsers() {
        return this.noUsersTable.timed().isPresent();
    }

    private FeatureMatcher<UserTableRow, String> username(Matcher<String> matcher) {
        return new FeatureMatcher<UserTableRow, String>(matcher, "username column in UserTableRow", "username"){

            protected String featureValueOf(UserTableRow actual) {
                return (String)actual.getUsername().now();
            }
        };
    }
}

