/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.bitbucket.pageobjects.element.Flag;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model.BranchTypeConfigurationField;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public abstract class AbstractBranchModelSettingsPage<T extends AbstractBranchModelSettingsPage<T, U, V>, U extends AbstractDevelopmentBranchConfiguration<U>, V extends AbstractProductionBranchConfiguration<V>>
extends BaseSidebarPage {
    public static final String BUGFIX_TYPE_ID = "BUGFIX";
    public static final String FEATURE_TYPE_ID = "FEATURE";
    public static final String HOTFIX_TYPE_ID = "HOTFIX";
    public static final String RELEASE_TYPE_ID = "RELEASE";
    @ElementBy(className="save-button")
    protected PageElement saveButton;
    @ElementBy(cssSelector="div[testid='cascading-merge-status'] input[value=\"ENABLED\"]")
    protected PageElement cascadingMerge;
    @ElementBy(cssSelector="div[testid='cascading-merge-behaviour'] input[value=\"ENABLED\"]")
    protected PageElement cascadingMergeCheck;
    @ElementBy(cssSelector="div[testid='delete-source-branch'] input[value=\"ENABLED\"]")
    protected PageElement deleteSourceEnabled;
    @ElementBy(cssSelector="div[testid='delete-source-branch'] input[value=\"DISABLED\"]")
    protected PageElement deleteSourceDisabled;
    @ElementBy(cssSelector="[data-testid=\"update-success\"]")
    protected PageElement updateSuccessfulMessage;
    @ElementBy(className="cancel-button")
    protected PageElement cancelLink;

    public T cancelChanges() {
        this.scrollToBottom();
        this.cancelLink.click();
        return this.self();
    }

    public T enableCascadingMerge() {
        Poller.waitUntilTrue(this.isCascadingMergeFieldEnabled());
        this.cascadingMerge.select();
        Poller.waitUntilTrue(this.isCascadingMergeEnabled());
        return this.self();
    }

    public T enableCascadingMergeCheck() {
        Poller.waitUntilTrue(this.isCascadingMergeCheckFieldEnabled());
        this.cascadingMergeCheck.select();
        Poller.waitUntilTrue(this.isCascadingMergeCheckEnabled());
        return this.self();
    }

    public T enableDeleteSource() {
        this.deleteSourceEnabled.select();
        return this.self();
    }

    public T disabledDeleteSource() {
        this.deleteSourceDisabled.select();
        return this.self();
    }

    public T dismissFlag() {
        ((Flag)((List)Poller.waitUntil(this.getAllFlags(), (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()))).get(0)).dismiss();
        return this.self();
    }

    public TimedQuery<List<Flag>> getAllFlags() {
        return Queries.forSupplier((Timeouts)this.timeouts, this::getFlags);
    }

    public BranchTypeConfigurationField getBranchTypeConfiguration(String branchTypeId) {
        return (BranchTypeConfigurationField)this.pageBinder.bind(BranchTypeConfigurationField.class, new Object[]{branchTypeId});
    }

    public abstract AbstractDevelopmentBranchConfiguration<U> getDevelopmentConfiguration();

    public abstract AbstractProductionBranchConfiguration<V> getProductionConfiguration();

    public boolean isCancelLinkEnabled() {
        return this.cancelLink.isEnabled();
    }

    public TimedQuery<Boolean> isCascadingMergeChecked() {
        return this.cascadingMerge.timed().isSelected();
    }

    public TimedQuery<Boolean> isCascadingMergeEnabled() {
        return Conditions.and((TimedQuery[])new TimedQuery[]{this.isCascadingMergeFieldEnabled(), this.cascadingMerge.timed().isSelected()});
    }

    public TimedQuery<Boolean> isCascadingMergeCheckEnabled() {
        return Conditions.and((TimedQuery[])new TimedQuery[]{this.isCascadingMergeCheckFieldEnabled(), this.cascadingMergeCheck.timed().isSelected()});
    }

    public TimedQuery<Boolean> isCascadingMergeFieldEnabled() {
        return this.cascadingMerge.timed().isEnabled();
    }

    public TimedQuery<Boolean> isCascadingMergeCheckFieldEnabled() {
        return this.cascadingMergeCheck.timed().isEnabled();
    }

    public boolean isDeleteSourceChecked() {
        return this.deleteSourceEnabled.isSelected();
    }

    public boolean isDeleteSourceFieldEnabled() {
        return this.deleteSourceEnabled.isEnabled();
    }

    public boolean isDeleteSourceUnchecked() {
        return this.deleteSourceDisabled.isSelected();
    }

    public abstract TimedQuery<Boolean> isRestricted();

    public boolean isSaveButtonEnabled() {
        return this.saveButton.isEnabled();
    }

    public boolean isSuccessfulUpdate() {
        return this.updateSuccessfulMessage.isPresent();
    }

    public T clickSave() {
        this.saveButton.click();
        return this.rebind();
    }

    protected T self() {
        return (T)this;
    }

    abstract T rebind();

    public static abstract class AbstractProductionBranchConfiguration<T extends AbstractProductionBranchConfiguration<T>>
    extends AbstractBranchConfiguration<T> {
        public AbstractProductionBranchConfiguration() {
            super("production");
        }

        private PageElement getNoProductionBranch() {
            return this.finder.find(By.cssSelector((String)"input[name='production'][value='NONE']"));
        }

        public boolean isNoProductionBranch() {
            return this.getNoProductionBranch().hasAttribute("checked", "true");
        }

        public void selectNoProductionBranch() {
            this.getNoProductionBranch().select();
        }
    }

    public static abstract class AbstractDevelopmentBranchConfiguration<T extends AbstractDevelopmentBranchConfiguration<T>>
    extends AbstractBranchConfiguration<T> {
        public AbstractDevelopmentBranchConfiguration() {
            super("development");
        }
    }

    public static abstract class AbstractBranchConfiguration<T extends AbstractBranchConfiguration<T>> {
        protected final String type;
        @Inject
        protected PageBinder pageBinder;
        @Inject
        protected PageElementFinder finder;

        public AbstractBranchConfiguration(String type) {
            this.type = type;
        }

        public abstract T clearBranchNameField();

        public abstract TimedQuery<String> getBranchName();

        public PageElement getError() {
            return this.finder.find(By.cssSelector((String)("[data-testid='" + this.type + "-branch-error']")));
        }

        protected PageElement getUseBranchName() {
            return this.finder.find(By.cssSelector((String)("input[name='" + this.type + "'][value='BRANCH_NAME']")));
        }

        protected PageElement getUseDefaultBranch() {
            return this.finder.find(By.cssSelector((String)("input[name='" + this.type + "'][value='DEFAULT']")));
        }

        public boolean isUseDefaultBranch() {
            return this.getUseDefaultBranch().hasAttribute("checked", "true");
        }

        public T selectUseBranchName() {
            Poller.waitUntilTrue((TimedQuery)this.getUseBranchName().select().timed().isSelected());
            return this.self();
        }

        public T selectUseDefaultBranch() {
            Poller.waitUntilTrue((TimedQuery)this.getUseDefaultBranch().select().timed().isSelected());
            return this.self();
        }

        public abstract T typeBranchName(String var1);

        protected T self() {
            return (T)this;
        }
    }
}

