/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.TimedElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.admin.settings.branch.model.AbstractBranchModelSettingsPage;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public abstract class AbstractBranchModelRepositorySettingsPage<T extends AbstractBranchModelRepositorySettingsPage<T>>
extends AbstractBranchModelSettingsPage<T, RepositoryDevelopmentBranchConfiguration, RepositoryProductionBranchConfiguration> {
    private final String projectKey;
    private final String slug;

    public AbstractBranchModelRepositorySettingsPage(String projectKey, String slug) {
        this.projectKey = projectKey;
        this.slug = slug;
    }

    public TimedElement getConfirmationDialog() {
        return this.getPageElementByCSS("[data-testid=\"confirm-action-modal\"]").timed();
    }

    public RepositoryDevelopmentBranchConfiguration getDevelopmentConfiguration() {
        return (RepositoryDevelopmentBranchConfiguration)this.pageBinder.bind(RepositoryDevelopmentBranchConfiguration.class, new Object[0]);
    }

    public PageElement getPageElementByCSS(String cssSelector) {
        return this.elementFinder.find(By.cssSelector((String)cssSelector));
    }

    public RepositoryProductionBranchConfiguration getProductionConfiguration() {
        return (RepositoryProductionBranchConfiguration)this.pageBinder.bind(RepositoryProductionBranchConfiguration.class, new Object[0]);
    }

    public String getUrl() {
        return "/plugins/servlet/branchmodel/projects/" + this.projectKey + "/repos/" + this.slug;
    }

    @Override
    protected T rebind() {
        return (T)((AbstractBranchModelRepositorySettingsPage)this.pageBinder.bind(this.getClass(), new Object[]{this.projectKey, this.slug}));
    }

    public static class RepositoryProductionBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractProductionBranchConfiguration<RepositoryProductionBranchConfiguration> {
        @Override
        public RepositoryProductionBranchConfiguration clearBranchNameField() {
            PageElement branchSelector = this.getBranchNameSelector();
            PageElement input = branchSelector.find(By.tagName((String)"input"));
            input.clear();
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            PageElement branchSelector = this.getBranchNameSelector();
            if (branchSelector.isPresent()) {
                return branchSelector.find(By.className((String)"filterable-tabs__single-value")).timed().getText();
            }
            return this.finder.find(By.cssSelector((String)("input[name='branch-model-" + this.type + "']"))).timed().getValue();
        }

        private PageElement getBranchNameSelector() {
            return this.finder.find(By.className((String)("significant-" + this.type + "-branch-trigger")));
        }

        @Override
        public RepositoryProductionBranchConfiguration typeBranchName(String name) {
            PageElement branchSelector = this.getBranchNameSelector();
            PageElement input = branchSelector.find(By.tagName((String)"input"));
            input.type(new CharSequence[]{name});
            Poller.waitUntilFalse((TimedQuery)branchSelector.find(By.cssSelector((String)".filterable-tabs__indicators circle")).timed().isPresent());
            input.type(new CharSequence[]{Keys.ENTER});
            return this;
        }
    }

    public static class RepositoryDevelopmentBranchConfiguration
    extends AbstractBranchModelSettingsPage.AbstractDevelopmentBranchConfiguration<RepositoryDevelopmentBranchConfiguration> {
        @Override
        public RepositoryDevelopmentBranchConfiguration clearBranchNameField() {
            PageElement branchSelector = this.getBranchNameSelector();
            PageElement input = branchSelector.find(By.tagName((String)"input"));
            input.clear();
            return this;
        }

        @Override
        public TimedQuery<String> getBranchName() {
            PageElement branchSelector = this.getBranchNameSelector();
            if (branchSelector.isPresent()) {
                return branchSelector.find(By.className((String)"filterable-tabs__single-value")).timed().getText();
            }
            return this.finder.find(By.cssSelector((String)("input[name='branch-model-" + this.type + "']"))).timed().getValue();
        }

        private PageElement getBranchNameSelector() {
            return this.finder.find(By.className((String)("significant-" + this.type + "-branch-trigger")));
        }

        @Override
        public RepositoryDevelopmentBranchConfiguration typeBranchName(String name) {
            PageElement branchSelector = this.getBranchNameSelector();
            PageElement input = branchSelector.find(By.tagName((String)"input"));
            input.type(new CharSequence[]{name});
            Poller.waitUntilFalse((TimedQuery)branchSelector.find(By.cssSelector((String)".filterable-tabs__indicators circle")).timed().isPresent());
            input.type(new CharSequence[]{Keys.ENTER});
            return this;
        }
    }
}

