/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.RepositoryManagementPage;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public abstract class BulkActionConfirmationDialog
extends AbstractElementPageObject {
    @Nonnull
    private final RepositoryManagementPage page;

    public BulkActionConfirmationDialog(@Nonnull RepositoryManagementPage page, @Nonnull PageElement container) {
        super(container);
        this.page = page;
    }

    public void clickConfirm() {
        this.confirmActionsButton().click();
    }

    public RepositoryManagementPage close() {
        PageElement button = this.container.find(By.id((String)"finish-actions"));
        Poller.waitUntilTrue((TimedQuery)button.timed().isEnabled());
        button.click();
        Poller.waitUntilFalse((TimedQuery)this.container.timed().isPresent());
        return this.page;
    }

    public TimedQuery<String> getFailure() {
        return this.container.find(By.className((String)"bulk-action-failed")).timed().getText();
    }

    public TimedQuery<String> getProgress() {
        return this.container.find(By.cssSelector((String)".progress-text > span.count")).timed().getText();
    }

    public TimedQuery<String> getSuccess() {
        return this.container.find(By.className((String)"bulk-action-success")).timed().getText();
    }

    public String getTitle() {
        return this.container.find(By.cssSelector((String)"[data-testid='bulk-action-heading']")).getText();
    }

    public boolean isConfirmActionsEnabled() {
        return this.confirmActionsButton().isEnabled();
    }

    public TimedCondition isProgressBarVisible() {
        return this.container.find(By.className((String)"bulk-action-progress-bar")).timed().isVisible();
    }

    private PageElement confirmActionsButton() {
        return this.container.find(By.id((String)"confirm-actions"));
    }
}

