/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.Protocol;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.ProtocolMenu;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.TextMenu;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;

public class MirrorCloneRepoDialog
extends AbstractElementPageObject {
    protected static final String ID = "repo-clone-dialog";
    @ElementBy(className="clone-url-input")
    private PageElement cloneUrlInput;
    @Inject
    private PageElementFinder elementFinder;
    private TextMenu mirrorMenu;
    private ProtocolMenu protocolMenu;
    @Inject
    private Timeouts timeouts;

    public MirrorCloneRepoDialog(PageElement container) {
        super(container);
    }

    @Init
    public void init() {
        this.mirrorMenu = new TextMenu(this.elementFinder, By.id((String)"available-mirrors-trigger"), "available-mirrors");
        this.protocolMenu = new ProtocolMenu(this.elementFinder, By.className((String)"repository-protocol"), "repository-protocol-selector");
    }

    public String getCloneUrl() {
        return StringUtils.stripToNull((String)this.cloneUrlInput.getValue());
    }

    @WaitUntil
    public void mirrorsResolved() {
        long timeout = this.timeouts.timeoutFor(TimeoutType.SLOW_PAGE_LOAD);
        TimedCondition condition = Conditions.forSupplier((long)timeout, () -> this.elementFinder.findAll(By.className((String)"mirror-item")).size() >= 2);
        Poller.waitUntilTrue((String)"Waiting for mirrors to resolve.", (TimedQuery)condition);
    }

    public void selectMirror(String mirror) {
        this.mirrorMenu.select(mirror);
    }

    public void selectProtocol(Protocol protocol) {
        this.protocolMenu.select(protocol);
    }
}

