/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.admin.users.UserTablePage;
import org.junit.Assert;

public class UserAnonymizePage
extends BitbucketPage {
    @ElementBy(className="anonymize-button")
    private PageElement anonymizeButton;
    @ElementBy(id="user-anonymize-confirm")
    private AuiCheckbox anonymizeCheckbox;
    @ElementBy(className="back-button")
    private PageElement backButton;
    @ElementBy(className="continue-button")
    private PageElement continueButton;
    @ElementBy(className="error")
    private PageElement errorMessage;
    @ElementBy(id="username")
    private PageElement usernameTextbox;

    public UserTablePage clickAnonymize() {
        Poller.waitUntilTrue((TimedQuery)this.anonymizeButton.timed().isEnabled());
        this.anonymizeButton.click();
        return (UserTablePage)this.pageBinder.bind(UserTablePage.class, new Object[0]);
    }

    public UserAnonymizePage clickBack() {
        this.backButton.click();
        return this;
    }

    public UserAnonymizePage clickContinue() {
        this.continueButton.click();
        return this;
    }

    public UserAnonymizePage confirmCheckbox() {
        this.anonymizeCheckbox.check();
        Poller.waitUntilTrue((TimedQuery)this.anonymizeCheckbox.timed().isSelected());
        return this;
    }

    public String getUrl() {
        return "/admin/users/anonymize";
    }

    public String getUserTextboxValue() {
        return this.usernameTextbox.getValue();
    }

    public boolean isAnonymizeButtonEnabled() {
        return this.anonymizeButton.isEnabled();
    }

    public boolean isAnonymizeCheckboxChecked() {
        return this.anonymizeCheckbox.isChecked();
    }

    public boolean isContinueButtonEnabled() {
        return this.continueButton.isEnabled();
    }

    public void assertErrorMessageIsVisible() {
        Poller.waitUntilTrue((TimedQuery)this.errorMessage.timed().isVisible());
        Assert.assertTrue((boolean)this.errorMessage.isVisible());
    }

    public UserAnonymizePage setUsername(String username) {
        this.usernameTextbox.clear().type(new CharSequence[]{username});
        return this;
    }

    public void waitForConfirmationStep() {
        Poller.waitUntilTrue((TimedQuery)this.anonymizeCheckbox.timed().isVisible());
    }

    public void waitForValidationStep() {
        Poller.waitUntilTrue((TimedQuery)this.usernameTextbox.timed().isVisible());
    }
}

