/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.LicenseCrossgradeWarningDialog;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.LicensePage;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class LicenseEditPage
extends BitbucketPage {
    @ElementBy(id="submit")
    private PageElement submitButton;
    @ElementBy(id="cancel")
    private PageElement cancelButton;

    @WaitUntil
    public void waitUntilVisible() {
        Poller.waitUntilTrue((TimedQuery)this.submitButton.timed().isVisible());
    }

    public String getUrl() {
        return "/admin/license?edit";
    }

    public String getServerId() {
        return this.driver.findElement(By.id((String)"serverid")).getText();
    }

    public String getLicense() {
        return this.driver.findElement(By.id((String)"license")).getText();
    }

    public LicenseEditPage setLicense(String license) {
        WebElement licenseElement = this.driver.findElement(By.id((String)"license"));
        licenseElement.clear();
        licenseElement.sendKeys(new CharSequence[]{license});
        return this;
    }

    public String getLicenseError() {
        WebElement error = this.driver.findElement(By.cssSelector((String)"#license + .error"));
        if (error != null) {
            return error.getText();
        }
        return null;
    }

    public String getServerLicenseError() {
        WebElement error = this.driver.findElement(By.cssSelector((String)".not-data-center-error"));
        if (error != null) {
            return error.getText();
        }
        return null;
    }

    public LicensePage saveSuccessfully() {
        this.submitButton.click();
        return (LicensePage)this.pageBinder.bind(LicensePage.class, new Object[0]);
    }

    public LicenseEditPage saveUnsuccessfully() {
        this.submitButton.click();
        return (LicenseEditPage)this.pageBinder.bind(LicenseEditPage.class, new Object[0]);
    }

    public LicensePage cancel() {
        this.cancelButton.click();
        return (LicensePage)this.pageBinder.bind(LicensePage.class, new Object[0]);
    }

    public LicenseCrossgradeWarningDialog getCrossgradeWarning() {
        return (LicenseCrossgradeWarningDialog)((Object)this.pageBinder.bind(LicenseCrossgradeWarningDialog.class, new Object[0]));
    }
}

