/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.dashboard;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.AbstractTimedCondition;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.BuildStatusIcon;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class DashboardPullRequestSection
extends AbstractElementPageObject {
    public DashboardPullRequestSection(@Nonnull PageElement container) {
        super(container);
    }

    public void clickShowMore() {
        final int initialCount = this.getPullRequests().size();
        PageElement showMoreButton = this.container.find(By.className((String)"show-more"));
        ElementUtils.scrollIntoView(showMoreButton);
        showMoreButton.click();
        Poller.waitUntilTrue((String)"The number of visible PRs has increased", (TimedQuery)new AbstractTimedCondition(5000L, 100L){

            protected Boolean currentValue() {
                return DashboardPullRequestSection.this.getPullRequests().size() > initialCount;
            }
        });
    }

    public PageElement getEmptyState() {
        return this.container.find(By.className((String)"empty-state"));
    }

    public List<PullRequestRow> getPullRequests() {
        return this.container.findAll(By.cssSelector((String)"tbody tr")).stream().map(ElementUtils.bind(this.pageBinder, PullRequestRow.class, new Object[0])).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.getPullRequests().isEmpty();
    }

    public Optional<PullRequestRow> getFocusedPullRequest() {
        PageElement pageElement = this.container.find(By.cssSelector((String)"tbody tr.focused"));
        if (!pageElement.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.pageBinder.bind(PullRequestRow.class, new Object[]{pageElement}));
    }

    public static class PullRequestRow
    extends AbstractElementPageObject {
        public PullRequestRow(@Nonnull PageElement container) {
            super(container);
        }

        public Optional<String> getBadge() {
            PageElement pageElement = this.container.find(By.cssSelector((String)"td.state-column > *"));
            if (!pageElement.isPresent()) {
                return Optional.empty();
            }
            return Optional.ofNullable(pageElement.getText());
        }

        public String getTitle() {
            return this.container.find(By.cssSelector((String)".title a")).getText();
        }

        public BuildStatusIcon getBuildStatus() {
            PageElement icon = this.container.find(By.cssSelector((String)"td.builds-column")).find(By.cssSelector((String)"[data-testid=\"build-summary-icon-link\"]"));
            return (BuildStatusIcon)this.pageBinder.bind(BuildStatusIcon.class, new Object[]{icon});
        }
    }
}

