/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.notification.PullRequestNotificationScope;
import com.atlassian.webdriver.bitbucket.element.notification.PushNotificationScope;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RepositoryNotificationSettingsDialog
extends AbstractElementPageObject {
    @ElementBy(cssSelector=".aui-dialog2-footer-actions .aui-button-link")
    private PageElement cancelButton;
    @ElementBy(cssSelector=".aui-dialog2-footer-actions .aui-button-primary")
    private PageElement saveButton;

    public RepositoryNotificationSettingsDialog(@Nonnull PageElement container) {
        super(container);
    }

    public void clickCancel() {
        this.cancelButton.click();
        Poller.waitUntilFalse((String)"The repository notification settings dialog should be closed", (TimedQuery)Conditions.forSupplier((long)5000L, () -> ((PageElement)this.container).isPresent()));
    }

    public void clickSave() {
        this.saveButton.click();
        Poller.waitUntilFalse((String)"The repository notification settings dialog should be closed", (TimedQuery)Conditions.forSupplier((long)5000L, () -> ((PageElement)this.container).isPresent()));
    }

    public PullRequestNotificationScope getPullRequestNotificationScope() {
        AuiCheckbox auiCheckbox = ElementUtils.findCheckbox((PageElementFinder)this.container, By.cssSelector((String)"input.radio[id^='pr-']:checked"));
        return PullRequestNotificationScope.fromElementId(auiCheckbox.getId());
    }

    public PushNotificationScope getPushNotificationScope() {
        AuiCheckbox auiCheckbox = ElementUtils.findCheckbox((PageElementFinder)this.container, By.cssSelector((String)"input.radio[id^='commits-']:checked"));
        return PushNotificationScope.fromElementId(auiCheckbox.getId());
    }

    public RepositoryNotificationSettingsDialog setPullRequestNotificationScope(PullRequestNotificationScope scope) {
        ElementUtils.findCheckbox((PageElementFinder)this.container, By.cssSelector((String)("input.radio#" + scope.getElementId()))).click();
        return this;
    }

    public RepositoryNotificationSettingsDialog setPushNotificationScope(PushNotificationScope scope) {
        ElementUtils.findCheckbox((PageElementFinder)this.container, By.cssSelector((String)("input.radio#" + scope.getElementId()))).click();
        return this;
    }
}

