/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.element.Flag;
import com.atlassian.bitbucket.pageobjects.element.permissions.AddOrEditPermissionDialog;
import com.atlassian.bitbucket.pageobjects.element.permissions.PermissionFilter;
import com.atlassian.bitbucket.pageobjects.element.permissions.PermissionListItem;
import com.atlassian.bitbucket.pageobjects.element.permissions.PermissionTable;
import com.atlassian.bitbucket.pageobjects.element.permissions.TypeFilter;
import com.atlassian.pageobjects.elements.CheckboxElement;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.openqa.selenium.By;

public abstract class ScopedPermissionsPage
extends BitbucketPage {
    @ElementBy(className="add-user-or-group-button")
    private PageElement addUserOrGroupButton;
    @ElementBy(className="permissions-empty-state-container")
    private PageElement emptyStateContainer;
    @ElementBy(className="permission-filter-select")
    private PageElement permissionFilter;
    @ElementBy(className="permissions-table")
    private PageElement permissionsTable;
    @ElementBy(cssSelector="[data-testid='permissions-public-access--hidden-checkbox']")
    private CheckboxElement publicAccessCheckbox;
    @ElementBy(cssSelector="[data-testid='permissions-public-access--checkbox-label']")
    private CheckboxElement publicAccessCheckboxLabel;
    @ElementBy(cssSelector="input[name='search-filter']")
    private PageElement searchBox;
    @ElementBy(className="type-filter-select")
    private PageElement typeFilter;

    public String getSelectedType() {
        return this.getTypeFilter().getSelectedType();
    }

    public AddOrEditPermissionDialog clickAddPermission() {
        this.addUserOrGroupButton.click();
        PageElement editPermissionModal = this.elementFinder.find(By.xpath((String)"//*[@data-testid='permission-modal']"));
        Poller.waitUntilTrue((TimedQuery)editPermissionModal.timed().isVisible());
        return (AddOrEditPermissionDialog)this.pageBinder.bind(AddOrEditPermissionDialog.class, new Object[]{editPermissionModal});
    }

    public ScopedPermissionsPage searchForUserOrGroup(String text) {
        this.clearSearchBox();
        this.searchBox.type(new CharSequence[]{text});
        return this;
    }

    public void selectAll() {
        this.getTypeFilter().selectAll();
    }

    public PermissionFilter getPermissionFilter() {
        return (PermissionFilter)this.pageBinder.bind(PermissionFilter.class, new Object[]{this.permissionFilter});
    }

    public TimedQuery<PermissionListItem> getPermissionForUserOrGroup(String userOrGroup) {
        return this.getPermissionTable().getPermissionForUserOrGroup(userOrGroup);
    }

    public TimedQuery<List<PermissionListItem>> getPermissions() {
        return this.emptyStateContainer.isPresent() ? Queries.forSupplier((Timeouts)this.timeouts, ImmutableList::of) : this.getPermissionTable().getPermissions();
    }

    public TimedQuery<List<Flag>> getAllFlags() {
        return Queries.forSupplier((Timeouts)this.timeouts, this::getFlags);
    }

    public TimedCondition isPermissionTableEmpty() {
        return this.emptyStateContainer.timed().isVisible();
    }

    public TimedCondition isPublicAccessEnabled() {
        return this.publicAccessCheckbox.timed().isEnabled();
    }

    public TimedCondition isPublicAccessSelected() {
        return this.publicAccessCheckbox.timed().isSelected();
    }

    public void selectGroup() {
        this.getTypeFilter().selectGroup();
    }

    public void selectUser() {
        this.getTypeFilter().selectUser();
    }

    private void clearSearchBox() {
        this.searchBox.clear();
    }

    public void setPublicAccess(boolean allowPublicAccess) {
        if (allowPublicAccess != this.publicAccessCheckbox.isChecked()) {
            this.publicAccessCheckboxLabel.click();
        }
        if (allowPublicAccess) {
            Poller.waitUntilTrue((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, () -> this.publicAccessCheckbox.isChecked()));
        } else {
            Poller.waitUntilFalse((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, () -> this.publicAccessCheckbox.isChecked()));
        }
    }

    private PermissionTable getPermissionTable() {
        return (PermissionTable)this.pageBinder.bind(PermissionTable.class, new Object[]{this.permissionsTable});
    }

    private TypeFilter getTypeFilter() {
        return (TypeFilter)this.pageBinder.bind(TypeFilter.class, new Object[]{this.typeFilter});
    }
}

