/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.element.ProjectSettingsRestrictionSelector;
import com.atlassian.bitbucket.pageobjects.page.ProjectAccessKeyFormPage;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AccessKeyRow;
import com.atlassian.webdriver.bitbucket.page.BaseProjectPage;
import com.atlassian.webdriver.bitbucket.util.Locators;
import java.util.List;

public class ProjectAccessKeySettingsPage
extends BaseProjectPage {
    @ElementBy(className="add-key-button")
    private PageElement addKeyButton;
    @ElementBy(className="project-settings-selector")
    private PageElement restrictionDropdown;
    @ElementBy(className="ssh-keys-table")
    private PageElement sshKeysTable;
    @ElementBy(cssSelector="[data-testid='ssh-key-actions-edit']")
    private PageElement sshKeyActionsEdit;

    public ProjectAccessKeySettingsPage(String key) {
        super(key);
    }

    public ProjectAccessKeyFormPage clickAddKeyButton() {
        Poller.waitUntilTrue((TimedQuery)this.isAddKeyButtonVisible());
        this.addKeyButton.click();
        return (ProjectAccessKeyFormPage)this.pageBinder.bind(ProjectAccessKeyFormPage.class, new Object[]{this.getProjectKey()});
    }

    public ProjectAccessKeyFormPage clickEditByKeyId(int keyId) {
        Poller.waitUntilTrue((TimedQuery)this.isSshKeysTablePresent());
        AccessKeyRow accessKeyRow = this.getAccessKeys().get(0);
        accessKeyRow.openDropdown();
        Poller.waitUntilTrue((TimedQuery)this.isDropdownVisible());
        this.sshKeyActionsEdit.click();
        return (ProjectAccessKeyFormPage)this.pageBinder.bind(ProjectAccessKeyFormPage.class, new Object[]{this.getProjectKey(), keyId});
    }

    public TimedCondition isAddKeyButtonVisible() {
        return this.addKeyButton.timed().isVisible();
    }

    public TimedCondition isDropdownVisible() {
        return this.sshKeyActionsEdit.timed().isVisible();
    }

    public TimedCondition isSshKeysTablePresent() {
        return this.sshKeysTable.timed().isPresent();
    }

    public List<AccessKeyRow> getAccessKeys() {
        return this.sshKeysTable.findAll(Locators.tableRow(), AccessKeyRow.class);
    }

    public ProjectSettingsRestrictionSelector getRestrictionDropdown() {
        return (ProjectSettingsRestrictionSelector)this.pageBinder.bind(ProjectSettingsRestrictionSelector.class, new Object[]{this.restrictionDropdown});
    }

    public String getUrl() {
        return String.format("/plugins/servlet/ssh/projects/%s/keys", this.getProjectKey());
    }

    public void waitUntilLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.sshKeysTable.timed().isVisible());
    }
}

