/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.permissions;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.testing.PageElementMatchers;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;

public class TypeFilter
extends AbstractElementPageObject {
    private static final String ALL = "All";
    private static final String GROUP = "Group";
    private static final String USER = "User";

    public TypeFilter(@Nonnull PageElement container) {
        super(container);
    }

    public String getSelectedType() {
        return this.container.find(By.className((String)"type-filter__single-value")).getText();
    }

    public void selectAll() {
        this.selectType(ALL);
    }

    public void selectGroup() {
        this.selectType(GROUP);
    }

    public void selectUser() {
        this.selectType(USER);
    }

    private TimedQuery<List<PageElement>> getOptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.container.findAll(By.className((String)"type-filter__option")));
    }

    private void selectType(String type) {
        this.container.click();
        ((List)Poller.waitUntil(this.getOptions(), (Matcher)CoreMatchers.hasItem((Matcher)PageElementMatchers.withText((String)type)))).stream().filter(p -> type.equals(p.getText())).findFirst().orElseThrow(() -> new AssertionError((Object)String.format("%s not found in the type filter drop-down", type))).click();
    }
}

