/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.setup;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.mirror.ApprovalRequiredPage;
import com.atlassian.webdriver.bitbucket.page.setup.SetupPage;
import org.apache.commons.lang3.StringUtils;

public class MirrorSetupPage
extends SetupPage {
    @ElementBy(id="baseUrl")
    private PageElement mirrorBaseUrl;
    @ElementBy(id="applicationTitle")
    private PageElement mirrorName;
    @ElementBy(id="upstreamUrl")
    private PageElement primaryServerUrl;
    @ElementBy(id="submit")
    private PageElement submitButton;

    @Override
    public String getStepHeading() {
        return "Configure mirror settings";
    }

    public boolean hasMirrorBaseUrlWarning() {
        return this.hasError(this.mirrorBaseUrl);
    }

    public boolean hasMirrorNameWarning() {
        return this.hasError(this.mirrorName);
    }

    public boolean hasPrimaryServerUrlWarning() {
        return this.hasError(this.primaryServerUrl);
    }

    public boolean isPrimaryServerUrlVisible() {
        return this.primaryServerUrl.isVisible();
    }

    public void setMirrorBaseUrl(String value) {
        this.mirrorBaseUrl.clear().type(new CharSequence[]{value});
    }

    public void setMirrorName(String value) {
        this.mirrorName.clear().type(new CharSequence[]{value});
    }

    public void setPrimaryServerUrl(String value) {
        this.primaryServerUrl.clear().type(new CharSequence[]{value});
    }

    public void clickSubmit() {
        this.submitButton.click();
    }

    public ApprovalRequiredPage submit() {
        this.clickSubmit();
        return (ApprovalRequiredPage)this.pageBinder.bind(ApprovalRequiredPage.class, new Object[0]);
    }

    private boolean hasError(PageElement inputElement) {
        String error = inputElement.getAttribute("data-aui-notification-error");
        return StringUtils.isNotBlank((CharSequence)error);
    }
}

