/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.compare;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import com.atlassian.webdriver.bitbucket.element.SourceTargetSelector;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestCreatePage;
import com.atlassian.webdriver.bitbucket.util.UrlUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.openqa.selenium.By;

@Deprecated
public abstract class ComparePage
extends BaseRepositoryPage {
    protected String tab;
    protected String source;
    protected String target;
    @ElementBy(className="swap-button")
    private PageElement swapBranchesButton;
    @ElementBy(id="show-create-pr-button")
    private PageElement createPullRequestButton;
    @ElementBy(className="branch-compare-errors")
    private PageElement compareError;

    public ComparePage(String projectKey, String slug, String tab) {
        super(projectKey, slug);
        this.tab = tab;
    }

    public ComparePage(String projectKey, String slug, String source, String target) {
        super(projectKey, slug);
        this.source = source;
        this.target = target;
    }

    public String getUrl() {
        String url = this.source != null || this.target != null ? String.format("/projects/%s/repos/%s/compare?sourceBranch=%s&targetBranch=%s", this.projectKey, this.slug, this.source, this.target) : (this.tab != null ? String.format("/projects/%s/repos/%s/compare/%s", this.projectKey, this.slug, this.tab) : String.format("/projects/%s/repos/%s/compare", this.projectKey, this.slug));
        return url;
    }

    public String getSourceBranchFromUrl() {
        return UrlUtils.getQueryParams(this.driver.getCurrentUrl()).get("sourceBranch");
    }

    public String getTargetBranchFromUrl() {
        return UrlUtils.getQueryParams(this.driver.getCurrentUrl()).get("targetBranch");
    }

    public <T extends ComparePage> T clickSwapBranches() {
        this.swapBranchesButton.click();
        return (T)((ComparePage)this.pageBinder.bind(this.getClass(), new Object[]{this.projectKey, this.slug}));
    }

    public SourceTargetSelector getSourceTargetSelector() {
        return (SourceTargetSelector)this.pageBinder.bind(SourceTargetSelector.class, new Object[0]);
    }

    public LinkElement getCreatePullRequestToolbarAction() {
        return (LinkElement)((Object)Iterables.find(this.getSidebar().getActionsLinks(), (Predicate)new Predicate<LinkElement>(){

            public boolean apply(LinkElement link) {
                return link.find(By.className((String)"icon-create-pull-request")).isPresent();
            }
        }));
    }

    public boolean hasCompareError() {
        return this.compareError.isPresent();
    }

    public String getCompareErrorText() {
        return this.compareError.getText();
    }

    public abstract ComparePage switchTab();

    public abstract ComparePage switchTabUsingKeyboard();

    protected <T extends ComparePage> T switchTab(Class<T> pageClass, String tabName) {
        this.elementFinder.find(By.cssSelector((String)(".menu-item[data-module-key=compare-" + tabName + "-tab] strong"))).click();
        return (T)((ComparePage)this.pageBinder.bind(pageClass, new Object[]{this.projectKey, this.slug}));
    }

    protected <T extends ComparePage> T switchTab(Class<T> pageClass, char keyboardKey) {
        this.useShortcut(Character.toString(keyboardKey));
        return (T)((ComparePage)this.pageBinder.bind(pageClass, new Object[]{this.projectKey, this.slug}));
    }

    public PullRequestCreatePage createPullRequest() {
        this.createPullRequestButton.click();
        return (PullRequestCreatePage)this.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.projectKey, this.slug});
    }

    public boolean isPullRequestButtonEnabled() {
        return this.createPullRequestButton.getAttribute("disabled") == null;
    }
}

