/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.reviewergroups;

import com.atlassian.bitbucket.pageobjects.element.ConfirmDialog;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class ReviewerGroupListItem
extends AbstractElementPageObject {
    private final PageElement actionsTrigger = this.find(By.className((String)"reviewer-group-actions"));
    private final PageElement deleteDropdownItem = this.find(By.cssSelector((String)"[data-testid='delete-group']"));
    private final PageElement editDropdownItem = this.find(By.cssSelector((String)"[data-testid='edit-group']"));
    private final PageElement groupName = this.find(By.className((String)"group-name"));
    private final PageElement inheritedLink = this.find(By.className((String)"project-settings-link"));
    @ElementBy(cssSelector="[data-testid='delete-reviewer-group-modal']")
    private PageElement deleteDialog;

    public ReviewerGroupListItem(@Nonnull PageElement container) {
        super(container);
        Poller.waitUntilTrue((TimedQuery)container.timed().isVisible());
    }

    public void clickEditGroup() {
        this.openActionsMenu();
        this.editDropdownItem.click();
    }

    public ConfirmDialog clickDeleteGroup() {
        this.openActionsMenu();
        this.deleteDropdownItem.click();
        return (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.deleteDialog});
    }

    public List<String> getGroupMembersName() {
        return (List)this.getGroupMembers().stream().map(element -> element.getAttribute("aria-label")).collect(MoreCollectors.toImmutableList());
    }

    public String getGroupName() {
        return this.groupName.getText();
    }

    public List<PageElement> getGroupMembers() {
        return this.container.findAll(By.cssSelector((String)".members [role='img']"));
    }

    public Boolean hasInheritedLink() {
        return this.inheritedLink.isVisible();
    }

    private ReviewerGroupListItem openActionsMenu() {
        this.actionsTrigger.click();
        Poller.waitUntilTrue((TimedQuery)this.deleteDropdownItem.timed().isVisible());
        return this;
    }
}

