/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.DeleteConfirmationDialog;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.MoveConfirmationDialog;
import com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement.RepositoryManagementPage;
import java.util.Objects;
import org.openqa.selenium.By;

public class RepositoryListItem
extends AbstractElementPageObject {
    private final RepositoryManagementPage page;

    public RepositoryListItem(PageElement container, RepositoryManagementPage page) {
        super(container);
        this.page = Objects.requireNonNull(page, "page");
    }

    public DeleteConfirmationDialog clickDelete() {
        this.container.find(By.cssSelector((String)"[data-testid='delete-repository']")).click();
        PageElement confirmationModal = this.container.find(By.xpath((String)"//*[@data-testid='delete-repository-modal']"));
        Poller.waitUntilTrue((TimedQuery)confirmationModal.timed().isVisible());
        return (DeleteConfirmationDialog)this.pageBinder.bind(DeleteConfirmationDialog.class, new Object[]{this.page, confirmationModal});
    }

    public MoveConfirmationDialog clickMove() {
        this.container.find(By.cssSelector((String)"[data-testid='move-repository']")).click();
        PageElement confirmationModal = this.container.find(By.xpath((String)"//*[@data-testid='move-repository-modal']"));
        Poller.waitUntilTrue((TimedQuery)confirmationModal.timed().isVisible());
        return (MoveConfirmationDialog)this.pageBinder.bind(MoveConfirmationDialog.class, new Object[]{this.page, confirmationModal});
    }

    public void clickRelatedRepos() {
        this.container.find(By.cssSelector((String)"[data-testid='view-related-repositories']")).click();
    }

    public String getProjectName() {
        return this.container.find(By.className((String)"project-link")).getText();
    }

    public String getRepositoryDescription() {
        return this.container.find(By.className((String)"repo-description")).getText();
    }

    public String getRepositoryName() {
        return this.container.find(By.className((String)"repository-link")).getText();
    }

    public String getRepositorySize() {
        return this.container.find(By.className((String)"repository-size-col")).getText();
    }

    public boolean isSelected() {
        return this.container.find(By.cssSelector((String)"[data-testid=\"select-repository--hidden-checkbox\"]")).isSelected();
    }

    public RepositoryListItem openActionsMenu() {
        this.container.find(By.cssSelector((String)"button[data-testid='actions-menu-trigger']")).click();
        Poller.waitUntilTrue((TimedQuery)this.container.find(By.cssSelector((String)"div[data-role='droplistContent']")).timed().isVisible());
        return this;
    }

    public void toggleSelect() {
        this.container.find(By.xpath((String)"td[1]")).click();
    }
}

