/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorConfigPage;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorItem;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorRequestItem;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorRequestPage;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;

public class MirrorsAdminPage
extends BitbucketPage {
    private static final String PENDING_APPROVAL_STATE = "Pending approval";
    @ElementBy(id="mirroring-upstream-container")
    private PageElement mirrorAdminContainer;

    public List<MirrorRequestItem> getMirrorRequests() {
        return (List)this.mirrorAdminContainer.findAll(By.xpath((String)".//tr[td[3][contains(.,'Pending approval')]]//a")).stream().map(x$0 -> new SimpleMirrorRequestItem((PageElement)x$0)).collect(MoreCollectors.toImmutableList());
    }

    public List<MirrorItem> getMirrors() {
        return (List)this.mirrorAdminContainer.findAll(By.xpath((String)".//tr[not(td[3][contains(.,'Pending approval')])]//a")).stream().map(x$0 -> new SimpleMirrorItem((PageElement)x$0)).collect(MoreCollectors.toImmutableList());
    }

    public String getUrl() {
        return "/plugins/servlet/admin/mirrors";
    }

    private class SimpleMirrorRequestItem
    implements MirrorRequestItem {
        private final PageElement element;

        private SimpleMirrorRequestItem(PageElement element) {
            this.element = element;
        }

        @Override
        public MirrorRequestPage click() {
            String url = this.element.getAttribute("href");
            this.element.click();
            Matcher m = Pattern.compile(Pattern.quote(MirrorsAdminPage.this.getUrl()) + "/(?<type>[^/]+)/(?<mirrorId>[^/]+)/authorize/(?<requestId>[^/]+)$").matcher(url);
            if (!m.find()) {
                throw new RuntimeException("Invalid URL: " + url);
            }
            return (MirrorRequestPage)MirrorsAdminPage.this.pageBinder.bind(MirrorRequestPage.class, new Object[]{m.group("type"), m.group("mirrorId"), m.group("requestId")});
        }

        @Override
        public String getName() {
            return this.element.find(By.xpath((String)"./ancestor::tr/td[1]")).getText();
        }
    }

    private class SimpleMirrorItem
    implements MirrorItem {
        private final PageElement element;

        private SimpleMirrorItem(PageElement element) {
            this.element = element;
        }

        @Override
        public MirrorConfigPage click() {
            String url = this.element.getAttribute("href");
            this.element.click();
            Matcher m = Pattern.compile(Pattern.quote(MirrorsAdminPage.this.getUrl()) + "/(?<type>[^/]+)/(?<mirrorId>[^/]+)$").matcher(url);
            if (!m.find()) {
                throw new RuntimeException("Invalid URL: " + url);
            }
            return (MirrorConfigPage)MirrorsAdminPage.this.pageBinder.bind(MirrorConfigPage.class, new Object[]{m.group("type"), m.group("mirrorId")});
        }

        @Override
        public String getName() {
            return this.element.find(By.xpath((String)"./ancestor::tr/td[1]")).getText();
        }
    }
}

