/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.AbstractMirrorConfigPage;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorNodesConfigPage;
import org.openqa.selenium.By;

public class MirrorConfigPage
extends AbstractMirrorConfigPage {
    public MirrorConfigPage(String type, String mirrorId) {
        super(type, mirrorId);
    }

    public MirrorConfigPage addProject(String projectName) {
        this.inConnectFrame(() -> {
            PageElement projectSelector = this.elementFinder.find(By.cssSelector((String)".project-selector .selector input"));
            PageElement addButton = this.elementFinder.find(By.cssSelector((String)".project-selector button"));
            PageElement autoCompleteResult = this.elementFinder.find(By.xpath((String)("//*[@class='project-selector-option' and ./span[2]/text()='" + projectName + "']")));
            PageElement selectedResult = this.elementFinder.find(By.cssSelector((String)".project-selector")).find(By.xpath((String)(".//*[@class='project-selector-label' and text()='" + projectName + "']")));
            projectSelector.clear().type(new CharSequence[]{projectName});
            Poller.waitUntilTrue((TimedQuery)autoCompleteResult.withTimeout(TimeoutType.AJAX_ACTION).timed().isPresent());
            autoCompleteResult.click();
            Poller.waitUntilTrue((TimedQuery)selectedResult.timed().isVisible());
            addButton.click();
            PageElement project = this.getProjectRow(projectName);
            Poller.waitUntilTrue((TimedQuery)project.timed().isPresent());
        });
        return this;
    }

    @WaitUntil
    public void ensureConnectIFrameLoaded() {
        this.inConnectFrame(() -> {
            PageElement projectSelector = this.elementFinder.find(By.cssSelector((String)".project-selector .selector input"));
            Poller.waitUntilTrue((TimedQuery)projectSelector.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
        });
    }

    public MirrorAllDialog mirrorAll() {
        this.inConnectFrame(() -> this.elementFinder.find(By.cssSelector((String)".mirror-project-config header button")).click());
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"*.ap-dialog-container[id$=_mirror-all-confirm]")).timed().isPresent());
        return (MirrorAllDialog)this.pageBinder.bind(MirrorAllDialog.class, new Object[]{this});
    }

    public MirrorConfigPage removeProject(String projectName) {
        this.inConnectFrame(() -> {
            PageElement projectRow = this.getProjectRow(projectName);
            PageElement removeProject = projectRow.find(By.xpath((String)".//button"));
            removeProject.click();
            Poller.waitUntilFalse((TimedQuery)projectRow.timed().isVisible());
        });
        return this;
    }

    public MirrorNodesConfigPage switchToNodesTab() {
        return this.switchToTab(MirrorNodesConfigPage.class, "Mirror nodes");
    }

    public MirrorConfigPage waitUntilFinishedSyncing() {
        this.inConnectFrame(() -> {
            PageElement progressBar = this.elementFinder.find(By.className((String)"mirror-project-sync"));
            Poller.waitUntilFalse((TimedQuery)progressBar.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
        });
        return this;
    }

    private PageElement getProjectRow(String projectName) {
        return this.elementFinder.find(By.xpath((String)("//*[@class='synced-projects']//span[text()='" + projectName + "']/ancestor::tr")));
    }

    public class MirrorAllDialog {
        @ElementBy(cssSelector="*.ap-dialog-container[id$=_mirror-all-confirm] iframe")
        private PageElement iframe;

        public MirrorConfigPage cancel() {
            this.inConnectFrame(() -> MirrorConfigPage.this.elementFinder.find(By.xpath((String)"//button[contains(.,'Cancel')]")).click());
            Poller.waitUntilFalse((TimedQuery)this.iframe.timed().isPresent());
            return MirrorConfigPage.this;
        }

        @WaitUntil
        public void ensureConnectIFrameLoaded() {
            this.inConnectFrame(() -> Poller.waitUntilTrue((TimedQuery)MirrorConfigPage.this.elementFinder.find(By.cssSelector((String)".dialog-content")).timed().isVisible()));
        }

        protected void inConnectFrame(Runnable runnable) {
            MirrorConfigPage.this.driver.switchTo().frame(this.iframe.getId());
            try {
                runnable.run();
            }
            finally {
                MirrorConfigPage.this.driver.switchTo().defaultContent();
            }
        }
    }
}

