/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import org.openqa.selenium.By;

public abstract class AbstractDatabasePage<P extends AbstractDatabasePage<P>>
extends BitbucketPage {
    @ElementBy(id="type")
    protected PageElement typeSelectBox;
    @ElementBy(id="hostname")
    protected PageElement hostnameField;
    @ElementBy(id="port")
    protected PageElement portField;
    @ElementBy(id="database")
    protected PageElement databaseField;
    @ElementBy(id="username")
    protected PageElement usernameField;
    @ElementBy(id="password")
    protected PageElement passwordField;

    public P selectMySQL() {
        this.typeSelectBox.find(By.cssSelector((String)"option[value='mysql']")).select();
        return (P)this;
    }

    public P selectPostgres() {
        this.typeSelectBox.find(By.cssSelector((String)"option[value='postgres']")).select();
        return (P)this;
    }

    public P enterHost(String host) {
        this.hostnameField.clear().type(new CharSequence[]{host});
        return (P)this;
    }

    public P enterPort(String port) {
        this.portField.clear().type(new CharSequence[]{port});
        return (P)this;
    }

    public P enterDatabaseName(String databaseName) {
        this.databaseField.clear().type(new CharSequence[]{databaseName});
        return (P)this;
    }

    public P enterUsername(String username) {
        this.usernameField.clear().type(new CharSequence[]{username});
        return (P)this;
    }

    public P enterPassword(String password) {
        this.passwordField.clear().type(new CharSequence[]{password});
        return (P)this;
    }
}

