/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.GitLfsRepositorySettingsFormFragment;
import com.atlassian.webdriver.bitbucket.page.RepositoryDeleteConfirmationPage;
import com.atlassian.webdriver.bitbucket.page.TranscodeDiffFormFragment;
import com.atlassian.webdriver.bitbucket.page.admin.repo.AuditRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.admin.repo.pushlog.PushLogPage;
import java.util.List;
import org.openqa.selenium.By;

public class RepositoryEditSettingsPage
extends BaseRepositoryPage {
    @ElementBy(id="audit-web-item-link-bitbucket")
    private PageElement auditLogMenuItem;
    @ElementBy(cssSelector="li > a[title='View Push Log']")
    private PageElement pushLogMenuItem;
    @ElementBy(name="name")
    private PageElement nameField;
    @ElementBy(name="forkable")
    private AuiCheckbox forkableCheckbox;
    @ElementBy(name="submit")
    private PageElement submitButton;
    @ElementBy(id="repository-settings-delete-button")
    private PageElement deleteButton;
    @ElementBy(className="stash-repository-edit-settings-form")
    private PageElement form;

    public RepositoryEditSettingsPage(String projectKey, String slug) {
        super(projectKey, slug);
    }

    public GitLfsRepositorySettingsFormFragment getGitLfsRepositorySettingsFormFragment() {
        return (GitLfsRepositorySettingsFormFragment)this.pageBinder.bind(GitLfsRepositorySettingsFormFragment.class, new Object[]{this});
    }

    public TranscodeDiffFormFragment getTranscodeDiffFormFragment() {
        return (TranscodeDiffFormFragment)this.pageBinder.bind(TranscodeDiffFormFragment.class, new Object[]{this});
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/settings", this.projectKey, this.slug);
    }

    public RepositoryEditSettingsPage setName(String name) {
        this.nameField.clear();
        this.nameField.type(new CharSequence[]{name});
        return this;
    }

    public RepositoryEditSettingsPage setForkable(boolean forkable) {
        if (this.forkableCheckbox.isSelected() != forkable) {
            this.forkableCheckbox.click();
        }
        return this;
    }

    public String getNameValue() {
        return this.nameField.getValue();
    }

    public boolean isDeleteShowing() {
        return this.deleteButton.isPresent();
    }

    public RepositoryDeleteConfirmationPage clickDelete() {
        this.deleteButton.click();
        return (RepositoryDeleteConfirmationPage)this.pageBinder.bind(RepositoryDeleteConfirmationPage.class, new Object[]{this.projectKey, this.slug});
    }

    public AuditRepositoryPage openAuditLog(int repositoryId) {
        this.auditLogMenuItem.click();
        return (AuditRepositoryPage)this.pageBinder.bind(AuditRepositoryPage.class, new Object[]{this.projectKey, repositoryId, this.slug, this.getProjectName(), this.getRepositoryName()});
    }

    public PushLogPage openPushLog() {
        this.pushLogMenuItem.click();
        return (PushLogPage)this.pageBinder.bind(PushLogPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryEditSettingsPage submitSuccess() {
        String slug = this.nameField.getValue();
        this.waitForPageLoad(() -> this.submitButton.click());
        return (RepositoryEditSettingsPage)this.pageBinder.bind(RepositoryEditSettingsPage.class, new Object[]{this.projectKey, slug});
    }

    public RepositoryEditSettingsPage submitFail() {
        this.submitButton.click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#submit:enabled")).timed().isPresent());
        return (RepositoryEditSettingsPage)this.pageBinder.bind(RepositoryEditSettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public List<String> getFieldsWithErrors() {
        return this.getFieldsWithErrors(this.form);
    }

    public boolean isNameFieldWithError() {
        return this.getFieldsWithErrors().contains("name");
    }
}

