/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AvatarPickerDialog;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.ProjectListPage;
import com.atlassian.webdriver.bitbucket.page.ProjectOverviewPage;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;

public class ProjectCreatePage
extends BitbucketPage {
    @ElementBy(name="name")
    private PageElement nameField;
    @ElementBy(name="key")
    private PageElement keyField;
    @ElementBy(name="description")
    private PageElement descriptionField;
    @ElementBy(id="avatar")
    private PageElement avatarField;
    @ElementBy(cssSelector=".avatar-picker-field img")
    private PageElement avatarImage;
    @ElementBy(id="avatar-picker-button")
    private PageElement avatarPickerButton;
    @ElementBy(name="submit")
    private PageElement submitButton;
    @ElementBy(name="cancel")
    private PageElement cancelButton;

    public String getUrl() {
        return "/projects?create";
    }

    @Override
    public void doWait() {
        Poller.waitUntilTrue((TimedQuery)this.body.timed().hasClass("project-create"));
    }

    public ProjectCreatePage setName(String name) {
        this.nameField.type(new CharSequence[]{name});
        return this;
    }

    public ProjectCreatePage setKey(String key) {
        this.keyField.type(new CharSequence[]{key});
        return this;
    }

    public ProjectCreatePage setDescription(String description) {
        this.descriptionField.type(new CharSequence[]{description});
        return this;
    }

    public ProjectCreatePage setAvatar(String imagePath) {
        this.avatarPickerButton.click();
        AvatarPickerDialog dialog = (AvatarPickerDialog)((Object)this.pageBinder.bind(AvatarPickerDialog.class, new Object[]{By.id((String)"avatar-picker-dialog"), this}));
        return (ProjectCreatePage)dialog.uploadImage(imagePath, true).clickDone();
    }

    public ProjectOverviewPage submitSuccess() {
        String key = this.keyField.getValue();
        this.submitButton.click();
        return (ProjectOverviewPage)this.pageBinder.bind(ProjectOverviewPage.class, new Object[]{key});
    }

    public ProjectCreatePage submitFail() {
        this.submitButton.click();
        return (ProjectCreatePage)this.pageBinder.bind(ProjectCreatePage.class, new Object[0]);
    }

    public ProjectListPage cancel() {
        this.cancelButton.click();
        return (ProjectListPage)this.pageBinder.bind(ProjectListPage.class, new Object[0]);
    }

    public AvatarPickerDialog<ProjectCreatePage> openAvatarPicker() {
        this.avatarPickerButton.click();
        return (AvatarPickerDialog)((Object)this.pageBinder.bind(AvatarPickerDialog.class, new Object[]{By.id((String)"avatar-picker-dialog"), this}));
    }

    public boolean hasNonDefaultAvatar() {
        return !StringUtils.isEmpty((CharSequence)this.avatarField.getAttribute("value")) && !StringUtils.isEmpty((CharSequence)this.avatarImage.getAttribute("src"));
    }
}

