/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.BranchList;
import com.atlassian.webdriver.bitbucket.element.DeleteConfirmationDialog;
import com.atlassian.webdriver.bitbucket.page.BranchLayoutPage;
import com.atlassian.webdriver.bitbucket.page.compare.CommitsComparePage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.UrlUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class BranchListPage
extends BranchLayoutPage {
    private final String baseRef;
    private final Long lastUpdated;

    public BranchListPage(String projectKey, String repoSlug) {
        this(projectKey, repoSlug, null, null);
    }

    public BranchListPage(String projectKey, String repoSlug, Long lastUpdated) {
        this(projectKey, repoSlug, lastUpdated, null);
    }

    public BranchListPage(String projectKey, String repoSlug, Long lastUpdated, String baseRef) {
        super(projectKey, repoSlug);
        this.baseRef = baseRef;
        this.lastUpdated = lastUpdated;
    }

    public String getUrl() {
        String url = "/projects/" + this.projectKey + "/repos/" + this.slug + "/branches";
        return StringUtils.isEmpty((CharSequence)this.baseRef) ? url : url + "?base=" + UrlUtils.uriEncode(this.baseRef);
    }

    public BranchListPage switchTo(String branch) {
        Long lastUpdated = ElementUtils.getLastUpdated(this.elementFinder.find(By.id((String)"branch-list")));
        this.getBranchSelector().open().selectItemByName(branch);
        return (BranchListPage)this.pageBinder.bind(BranchListPage.class, new Object[]{this.projectKey, this.slug, lastUpdated, branch});
    }

    public BranchList getBranchList() {
        return (BranchList)this.pageBinder.bind(BranchList.class, new Object[]{this, this.elementFinder.find(By.id((String)"branch-list")), this.elementFinder.find(By.className((String)"paged-table-filter-input")), this.lastUpdated});
    }

    public BranchListPage focusFilter() {
        this.useShortcut("f");
        return this;
    }

    public BranchListPage moveToNextBranch() {
        this.useShortcut("j");
        return this;
    }

    public BranchListPage moveToPreviousBranch() {
        this.useShortcut("k");
        return this;
    }

    public CommitsComparePage openCompare() {
        this.waitForPageLoad(() -> this.useShortcut("o"));
        return (CommitsComparePage)this.pageBinder.bind(CommitsComparePage.class, new Object[]{this.getProjectKey(), this.getSlug()});
    }

    public TimedCondition isLoadingTimed() {
        return this.elementFinder.find(By.cssSelector((String)".aui-page-panel-content .spinner")).timed().isVisible();
    }

    public BranchListPage deleteFocusedBranch() {
        this.useShortcut((CharSequence)Keys.DELETE);
        DeleteConfirmationDialog confirmDialog = (DeleteConfirmationDialog)((Object)this.pageBinder.bind(DeleteConfirmationDialog.class, new Object[]{By.id((String)"delete-branch-dialog"), TimeoutType.DIALOG_LOAD, BranchListPage.class, new Object[]{this.getProjectKey(), this.getSlug(), this.getBranchList().getLastUpdated()}}));
        return (BranchListPage)confirmDialog.clickConfirmAndBind();
    }
}

