/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.pageobjects.page.next.ComparePage;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.BuildStatusIcon;
import com.atlassian.webdriver.bitbucket.element.DeleteConfirmationDialog;
import com.atlassian.webdriver.bitbucket.element.PullRequestListDialog;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.BranchListPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestCreatePage;
import com.atlassian.webdriver.bitbucket.page.admin.settings.ref.restriction.RepoBranchPermissionsPage;
import com.atlassian.webdriver.bitbucket.page.compare.CommitsComparePage;
import com.atlassian.webdriver.bitbucket.util.DateUtils;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.time.Instant;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openqa.selenium.By;

public class BranchList {
    private final BranchListPage parent;
    private final PageElement tableElement;
    private final PageElement filterElement;
    private Long lastUpdated;
    @Inject
    private PageBinder pageBinder;
    @Inject
    private PageElementFinder elementFinder;

    public BranchList(BranchListPage parent, PageElement tableElement, PageElement filterElement, Long lastUpdated) {
        this.parent = parent;
        this.tableElement = tableElement;
        this.filterElement = filterElement;
        this.lastUpdated = lastUpdated;
    }

    @WaitUntil
    public void ensureLoaded() {
        ElementUtils.waitUntilUpdated(this.tableElement, this.lastUpdated);
        this.lastUpdated = ElementUtils.getLastUpdated(this.tableElement);
    }

    public List<BranchListEntry> getRows() {
        return ImmutableList.copyOf(this.rowIterator());
    }

    public BranchListEntry getRow(String name) {
        return MoreStreams.streamIterable(this.rowIterator()).filter((? super T input) -> input.getName().equals(name)).findFirst().orElse(null);
    }

    public BranchListEntry getRowOrFail(String name) {
        BranchListEntry entry = this.getRow(name);
        if (entry == null) {
            throw new RuntimeException(String.format("Unable to find branch '%s'.", name));
        }
        return entry;
    }

    public BranchListEntry getFocusedRow() {
        PageElement focusedElement = this.tableElement.find(By.cssSelector((String)"tbody > tr.focused"));
        Poller.waitUntilTrue((TimedQuery)focusedElement.timed().isVisible());
        return (BranchListEntry)this.pageBinder.bind(BranchListEntry.class, new Object[]{this, focusedElement});
    }

    public BranchListEntry getDefaultBranchRow() {
        return this.getRowWithLozenge("default branch");
    }

    public BranchListEntry getBaseBranchRow() {
        return this.getRowWithLozenge("base branch");
    }

    public List<String> getColumnNames() {
        List headers = this.tableElement.findAll(By.tagName((String)"th"));
        return Lists.transform((List)headers, PageElement::getText);
    }

    public BranchList loadNextPage() {
        PageElement messageElement = this.getMessageElement();
        if (!messageElement.isPresent()) {
            ElementUtils.scrollDocumentAndWait(this.tableElement);
        }
        return this;
    }

    public boolean isFilterFocused() {
        return (Boolean)this.filterElement.javascript().execute("return jQuery(arguments[0]).is(':focus')", new Object[0]);
    }

    public BranchList filter(String filterText) {
        ElementUtils.waitUntilUpdated(this.tableElement, () -> this.filterElement.type(new CharSequence[]{filterText}));
        return this;
    }

    public boolean isBuildStatusColumnVisible() {
        return this.tableElement.find(By.id((String)"build-status-branch-list-col")).isVisible();
    }

    private BranchListEntry getRowWithLozenge(String lozenge) {
        Poller.waitUntilFalse((TimedQuery)this.parent.isLoadingTimed());
        for (BranchListEntry row : this.getRows()) {
            if (!row.getLozenges().contains(lozenge)) continue;
            return row;
        }
        return null;
    }

    private PageElement getMessageElement() {
        return this.elementFinder.find(By.className((String)"paged-table-message"));
    }

    public String getMessageText() {
        PageElement message = this.getMessageElement();
        return message.isVisible() ? message.getText() : null;
    }

    public Long getLastUpdated() {
        return this.lastUpdated;
    }

    private Iterable<BranchListEntry> rowIterator() {
        return Iterables.transform((Iterable)this.tableElement.findAll(By.cssSelector((String)"tbody > tr")), element -> (BranchListEntry)this.pageBinder.bind(BranchListEntry.class, new Object[]{this, element}));
    }

    public static class BranchDeleteDialog
    extends DeleteConfirmationDialog<BranchListPage> {
        private static final String NOT_MERGED_ID = "delete-branch-not-merged-warning";
        private static final Pattern NOT_MERGED_MESSAGE = Pattern.compile("branch has (\\d+) commits?.*not on (.+)$");

        public BranchDeleteDialog(By locator, TimeoutType timeoutType, Class<BranchListPage> page, Object ... args) {
            super(locator, timeoutType, page, args);
        }

        public boolean hasNotMergedWarning() {
            return this.findNotMerged() != null;
        }

        public long getNotMergedCommitCount() {
            return Long.parseLong(this.getNotMergedMatcher().group(1));
        }

        public String getNotMergedBranch() {
            return this.getNotMergedMatcher().group(2);
        }

        private Matcher getNotMergedMatcher() {
            Matcher matcher = NOT_MERGED_MESSAGE.matcher(this.findNotMergedOrFail().getText());
            if (matcher.find()) {
                return matcher;
            }
            throw new RuntimeException("Unable to parse message in delete dialog.");
        }

        private PageElement findNotMerged() {
            PageElement element = this.dialogPanelBody.find(By.id((String)NOT_MERGED_ID));
            if (element.isPresent()) {
                return element;
            }
            return null;
        }

        private PageElement findNotMergedOrFail() {
            PageElement notMergedElement = this.findNotMerged();
            if (notMergedElement == null) {
                throw new RuntimeException("Dialog does not have not merged message.");
            }
            return notMergedElement;
        }
    }

    public static class BranchListEntry {
        private final BranchList parent;
        private final PageElement element;

        public BranchListEntry(BranchList parent, PageElement element) {
            this.parent = parent;
            this.element = element;
        }

        public String getId() {
            return this.element.getAttribute("data-id");
        }

        public String getName() {
            return this.getBranchLink().getText();
        }

        public List<String> getLozenges() {
            return Lists.newArrayList((Iterable)Lists.transform((List)this.element.findAll(By.className((String)"aui-lozenge")), losenge -> losenge.getText().toLowerCase()));
        }

        public Instant getUpdated() {
            PageElement timeElement = this.getColumn("last-updated-column").find(By.tagName((String)"time"));
            return timeElement.isPresent() ? DateUtils.parseServerTimestamp(timeElement.getAttribute("datetime")).toInstant() : null;
        }

        public Integer getAheadCount() {
            return this.getCommitCount("ahead");
        }

        public Integer getBehindCount() {
            return this.getCommitCount("behind");
        }

        public boolean hasBuildStatus() {
            PageElement cell = this.getColumn("build-status-branch-list-col");
            return cell.isPresent() && cell.find(By.className((String)"build-icon")).isPresent();
        }

        public BuildStatusIcon getBuildStatusIcon() {
            PageElement icon = this.getColumn("build-status-branch-list-col").find(By.className((String)"build-icon"));
            return (BuildStatusIcon)this.parent.pageBinder.bind(BuildStatusIcon.class, new Object[]{icon});
        }

        public String getAheadBehindToolTip() {
            PageElement graphElement = this.getColumn("ahead-behind-column").find(By.className((String)"ahead-behind-graph"));
            if (!graphElement.isPresent()) {
                graphElement = this.getColumn("ahead-behind-column");
            }
            return this.getTitle(graphElement);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDownloadLinkHref() {
            PageElement actionMenu = this.getActionMenu();
            PageElement downloadAction = actionMenu.find(By.className((String)"download-branch"));
            try {
                String string = downloadAction.isPresent() ? downloadAction.getAttribute("href") : null;
                return string;
            }
            finally {
                if (actionMenu.isVisible()) {
                    this.triggerActionMenu();
                }
            }
        }

        public String getPullRequestStatus() {
            PageElement lozenge = this.getColumn("pull-requests-column").find(By.className((String)"aui-lozenge"));
            if (lozenge.isPresent()) {
                return lozenge.getText();
            }
            return null;
        }

        public boolean hasPullRequestColumn() {
            PageElement pageElement = this.element.find(By.cssSelector((String)"td[headers=pull-requests-column]"));
            return pageElement.isPresent();
        }

        public String getPullRequestLinkTooltip() {
            PageElement link = this.getColumn("pull-requests-column").find(By.className((String)"pull-request-list-trigger"));
            if (link.isPresent()) {
                return this.getTitle(link);
            }
            return null;
        }

        public String getPullRequestLinkHref() {
            PageElement link = this.getColumn("pull-requests-column").find(By.tagName((String)"a"));
            if (link.isPresent()) {
                return link.getAttribute("href");
            }
            return null;
        }

        public PullRequestListDialog clickPullRequestLink() {
            this.getColumn("pull-requests-column").find(By.className((String)"pull-request-list-trigger")).click();
            return (PullRequestListDialog)((Object)this.parent.pageBinder.bind(PullRequestListDialog.class, new Object[]{By.id((String)"pull-request-list-dialog"), TimeoutType.DIALOG_LOAD}));
        }

        private Integer getCommitCount(String type) {
            PageElement countElement = this.getColumn("ahead-behind-column").find(By.cssSelector((String)("." + type + "-graph .count")));
            if (countElement.isPresent()) {
                String count = countElement.getText().trim();
                return count.isEmpty() ? 0 : Integer.parseInt(count);
            }
            return null;
        }

        private <T extends BaseRepositoryPage> T click(Class<T> comparePageClass, Object ... args) {
            this.getBranchLink().click();
            return (T)((BaseRepositoryPage)this.parent.pageBinder.bind(comparePageClass, args));
        }

        public CommitsComparePage click() {
            return this.click(CommitsComparePage.class, this.parent.parent.getProjectKey(), this.parent.parent.getSlug());
        }

        public ComparePage clickNext() {
            return this.click(ComparePage.class, new Object[]{this.parent.parent.getProjectKey(), this.parent.parent.getSlug(), ComparePage.Tab.COMMITS});
        }

        public RepoBranchPermissionsPage clickEditBranchPermissions() {
            this.clickAction("edit-permissions");
            return (RepoBranchPermissionsPage)this.parent.pageBinder.bind(RepoBranchPermissionsPage.class, new Object[]{this.parent.parent.getProjectKey(), this.parent.parent.getSlug()});
        }

        public PullRequestCreatePage clickCreatePullRequest() {
            this.clickAction("create-pull-request");
            return (PullRequestCreatePage)this.parent.pageBinder.bind(PullRequestCreatePage.class, new Object[]{this.parent.parent.getProjectKey(), this.parent.parent.getSlug()});
        }

        public BranchDeleteDialog clickDeleteBranch() {
            this.clickAction("delete-branch");
            return (BranchDeleteDialog)((Object)this.parent.pageBinder.bind(BranchDeleteDialog.class, new Object[]{By.id((String)"delete-branch-dialog"), TimeoutType.DIALOG_LOAD, BranchListPage.class, new Object[]{this.parent.parent.getProjectKey(), this.parent.parent.getSlug(), this.parent.lastUpdated}}));
        }

        public List<String> getActionClasses() {
            PageElement menu = this.parent.elementFinder.find(By.id((String)this.getActionMenuId()));
            return Lists.newArrayList((Iterable)Lists.transform((List)menu.findAll(By.tagName((String)"a")), input -> {
                String attribute = input.getAttribute("class");
                if (attribute != null) {
                    attribute = attribute.replace("active", "");
                    attribute = attribute.trim();
                }
                return attribute;
            }));
        }

        public void clickAction(String className) {
            this.findAction(className).click();
        }

        public boolean isAheadBehindNotAvailable() {
            return this.getColumn("ahead-behind-column").getText().contains("Not available");
        }

        public PageElement getActionMenu() {
            this.triggerActionMenu();
            PageElement menu = this.parent.elementFinder.find(By.id((String)this.getActionMenuId()));
            Poller.waitUntilTrue((TimedQuery)menu.timed().isVisible());
            return menu;
        }

        public PageElement getJiraIssuesColumn() {
            return this.getColumn("branch-list-jira-issues-col");
        }

        public String getJiraIssueKeys() {
            return this.getJiraIssuesColumn().find(By.tagName((String)"a")).getAttribute("data-issue-keys");
        }

        private PageElement findAction(String className) {
            return this.getActionMenu().find(By.className((String)className));
        }

        private String getActionMenuId() {
            return "branch-list-actions-menu-refs/heads/" + StringEscapeUtils.escapeHtml4((String)this.getName());
        }

        private PageElement getBranchLink() {
            return this.getColumn("branch-name-column").find(By.tagName((String)"a"));
        }

        private PageElement getColumn(String name) {
            PageElement pageElement = this.element.find(By.cssSelector((String)("td[headers=" + name + "]")));
            Poller.waitUntilTrue((String)("Column " + name + " should be present"), (TimedQuery)pageElement.timed().isPresent());
            return pageElement;
        }

        private String getTitle(PageElement graphElement) {
            String titleAttribute = graphElement.getAttribute("title");
            return titleAttribute == null || titleAttribute.isEmpty() ? graphElement.getAttribute("original-title") : titleAttribute;
        }

        private void triggerActionMenu() {
            this.element.find(By.className((String)"branch-list-action-trigger")).click();
        }
    }
}

