/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.reviewmode;

import com.atlassian.bitbucket.pageobjects.element.comments.Comment;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class ReviewCommentsDialog
extends AbstractElementPageObject {
    private final PageElement activitySpinner = this.find(By.className((String)"commented-activity-list-spinner"));
    private final PageElement closeModalButton = this.find(By.cssSelector((String)"[data-testid='close-modal-button']"));

    public ReviewCommentsDialog(@Nonnull PageElementFinder elementFinder) {
        super(elementFinder.find(By.cssSelector((String)"[data-testid='review-comments-dialog']")));
        Poller.waitUntilTrue((TimedQuery)this.container.timed().isVisible());
    }

    public void close() {
        this.closeModalButton.click();
        Poller.waitUntilFalse((TimedQuery)this.isVisible());
    }

    public List<Comment> getAllComments() {
        this.waitUntilReady();
        return (List)this.container.findAll(By.className((String)"comment-with-replies")).stream().map(ElementUtils.bind(this.pageBinder, Comment.class, new Object[0])).collect(MoreCollectors.toImmutableList());
    }

    private TimedCondition isVisible() {
        return this.container.timed().isVisible();
    }

    private void waitUntilReady() {
        Poller.waitUntilTrue((TimedQuery)this.isVisible());
        Poller.waitUntilFalse((TimedQuery)this.activitySpinner.timed().isPresent());
    }
}

