/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.ConfirmDialog;
import com.atlassian.bitbucket.pageobjects.element.PullRequestAvatar;
import com.atlassian.bitbucket.pageobjects.element.PullRequestMergeConfirmDialog;
import com.atlassian.bitbucket.pageobjects.element.reviewmode.CompleteReviewDialog;
import com.atlassian.bitbucket.pageobjects.element.veto.VetoDialog;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class PullRequestHeader
extends AbstractElementPageObject {
    private final PageElement addSelfAsReviewerButton = this.find(By.className((String)"add-self"));
    private final PageElement approveButton = this.find(By.className((String)"approve"));
    private final PageElement authorAvatar = this.find(By.cssSelector((String)"[data-testid='pull-request-author']"));
    private final PageElement destinationBranch = this.find(By.cssSelector((String)".ref-lozenge:last-child"));
    private final PageElement mergeButton = this.find(By.cssSelector((String)".merge-button-container > button"));
    private final PageElement moreActionsButton = this.find(By.className((String)"pull-request-more-actions"));
    private final PageElement moreActionsMenu = this.find(By.cssSelector((String)"[data-testid='more-actions--content']"));
    private final PageElement needsWorkButton = this.find(By.className((String)"needs-work"));
    private final PageElement reOpenButton;
    private final PageElement removeSelfAsReviewerButton = this.find(By.className((String)"manage-self-button"));
    private final PageElement sourceBranch;
    private final PageElement startReviewButton;
    private final PageElement state;
    private final PageElement tasksOverviewButton;
    private final PageElement tasksOverviewCount;
    private final PageElement title;
    private final PageElement vetoCount;
    private final PageElement vetoesButton;
    @ElementBy(cssSelector="[data-testid='decline-pull-request-modal']")
    private PageElement declineDialog;
    @ElementBy(cssSelector="[data-testid='delete-pull-request-modal']")
    private PageElement deleteDialog;
    @Inject
    private PageElementFinder elementFinder;

    public PullRequestHeader(@Nonnull PageElement container) {
        super(container);
        this.reOpenButton = this.find(By.className((String)"pull-request-reopen"));
        this.sourceBranch = this.find(By.cssSelector((String)".ref-lozenge-content:first-child"));
        this.startReviewButton = this.find(By.cssSelector((String)"[data-testid='review-mode-button']"));
        this.state = this.find(By.className((String)"pull-request-state-lozenge"));
        this.tasksOverviewButton = this.find(By.className((String)"tasks-overview-button"));
        this.tasksOverviewCount = this.find(By.className((String)"tasks-overview-count"));
        this.title = this.find(By.className((String)"pull-request-title"));
        this.vetoCount = this.find(By.className((String)"veto-count"));
        this.vetoesButton = this.find(By.className((String)"vetoes-button"));
    }

    public PullRequestHeader addSelfAsReviewer() {
        this.addSelfAsReviewerButton.click();
        Poller.waitUntilTrue((TimedQuery)this.approveButton.timed().isVisible());
        return this;
    }

    public ConfirmDialog clickDecline() {
        this.getActionByName("decline").click();
        return (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.declineDialog});
    }

    public ConfirmDialog clickDelete() {
        this.getActionByName("delete").click();
        return (ConfirmDialog)this.pageBinder.bind(ConfirmDialog.class, new Object[]{this.deleteDialog});
    }

    public void clickUnwatch() {
        this.getActionByName("unwatch").click();
    }

    public void clickWatch() {
        this.getActionByName("watch").click();
    }

    public PageElement getAddSelfAsReviewerButton() {
        return this.addSelfAsReviewerButton;
    }

    public PageElement getApproveButton() {
        return this.approveButton;
    }

    public String getAuthor() {
        return this.getAuthorAvatar().getUsername();
    }

    public PullRequestAvatar getAuthorAvatar() {
        return (PullRequestAvatar)this.pageBinder.bind(PullRequestAvatar.class, new Object[]{this.authorAvatar});
    }

    public String getDestinationBranch() {
        return this.extractBranchName(this.destinationBranch);
    }

    public PageElement getEditButton() {
        return this.getActionByName("edit");
    }

    public PageElement getMergeButton() {
        Poller.waitUntilFalse((TimedQuery)this.mergeButton.timed().hasAttribute("data-has-overlay", "true"));
        return this.mergeButton;
    }

    public PullRequestMergeConfirmDialog getMergeConfirmDialog() {
        return (PullRequestMergeConfirmDialog)this.pageBinder.bind(PullRequestMergeConfirmDialog.class, new Object[]{this.elementFinder});
    }

    public List<PageElement> getMoreActions() {
        Poller.waitUntilTrue((TimedQuery)this.isHeaderVisible());
        Poller.waitUntilTrue((TimedQuery)this.moreActionsButton.timed().isVisible());
        this.moreActionsButton.click();
        Poller.waitUntilTrue((TimedQuery)this.moreActionsMenu.timed().isVisible());
        return this.moreActionsMenu.findAll(By.cssSelector((String)"[role='menuitem']"));
    }

    public PageElement getNeedsWorkButton() {
        return this.needsWorkButton;
    }

    public PageElement getReOpenButton() {
        return this.reOpenButton;
    }

    public PageElement getRemoveSelfAsReviewerButton() {
        return this.removeSelfAsReviewerButton;
    }

    public List<PullRequestAvatar> getReviewers() {
        return (List)this.container.findAll(By.cssSelector((String)".pull-request-reviewers-list [data-testid='reviewer-avatar']")).stream().map(ElementUtils.bind(this.pageBinder, PullRequestAvatar.class, new Object[0])).collect(MoreCollectors.toImmutableList());
    }

    public String getSourceBranch() {
        return this.extractBranchName(this.sourceBranch);
    }

    public PageElement getStartReviewButton() {
        Poller.waitUntilTrue((TimedQuery)this.startReviewButton.timed().isVisible());
        return this.startReviewButton;
    }

    public PageElement getState() {
        return this.state;
    }

    public PageElement getTasksOverviewButton() {
        return this.tasksOverviewButton;
    }

    public PageElement getTasksOverviewCount() {
        return this.tasksOverviewCount;
    }

    public String getTitle() {
        return this.title.getText();
    }

    public int getVetoCount() {
        return Integer.parseInt(this.vetoCount.getText());
    }

    public PageElement getVetoesButton() {
        return this.vetoesButton;
    }

    public TimedCondition isHeaderVisible() {
        return this.container.timed().isVisible();
    }

    public boolean isWatching() {
        boolean isWatching = this.getActionByName("unwatch") != null;
        this.moreActionsButton.click();
        return isWatching;
    }

    public CompleteReviewDialog openCompleteReviewDialog() {
        this.getStartReviewButton().click();
        return (CompleteReviewDialog)this.pageBinder.bind(CompleteReviewDialog.class, new Object[]{this.elementFinder});
    }

    public VetoDialog openVetoesDialog() {
        this.getVetoesButton().withTimeout(TimeoutType.UI_ACTION).click();
        return (VetoDialog)this.pageBinder.bind(VetoDialog.class, new Object[]{this.find(By.className((String)"vetoes-container"))});
    }

    private String extractBranchName(PageElement refLozenge) {
        String[] branchNameSplit = refLozenge.getText().split(" \u203a ");
        return branchNameSplit.length > 1 ? branchNameSplit[1] : branchNameSplit[0];
    }

    private PageElement getActionByName(String buttonName) {
        return this.getMoreActions().stream().filter(action -> buttonName.equalsIgnoreCase(action.getText())).findFirst().orElse(null);
    }
}

