/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.codeinsights.FileReportsDialog;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class DiffToolbar
extends AbstractElementPageObject {
    private final PageElement addFileComment = this.find(By.cssSelector((String)"[data-testid='diff-comment-trigger']"));
    private final PageElement changeTypeLozenge = this.find(By.cssSelector((String)"[data-testid='change-lozenge']"));
    private final PageElement diffOptionsDropdownContent = this.find(By.className((String)"diff-options-dropdown-content"));
    private final PageElement diffOptionsDropdownTrigger = this.find(By.cssSelector((String)"[data-testid='diff-options-dropdown-trigger']"));
    private final PageElement fileName = this.find(By.className((String)"file-breadcrumbs-segment-highlighted"));
    private final PageElement filePath = this.find(By.className((String)"file-breadcrumbs"));
    private final PageElement fileReportsButton = this.find(By.cssSelector((String)"[data-testid='file-reports-button']"));
    private final PageElement fileReportsDialog = this.find(By.className((String)"file-reports-dialog"));
    private final PageElement showAnnotationsRadio = this.find(By.id((String)"showAnnotations"));
    private final PageElement showCodeCoverageRadio = this.find(By.id((String)"showCoverage"));
    private final PageElement showCommentsAndTasksRadio = this.find(By.id((String)"showComments"));
    private final PageElement sideBySideDiffRadio = this.find(By.id((String)"diffMode-SIDE_BY_SIDE"));
    private final PageElement unifiedDiffRadio = this.find(By.id((String)"diffMode-UNIFIED"));
    private final PageElement viewSourceLink = this.find(By.cssSelector((String)"[data-testid='diff-view-source-button']"));

    public DiffToolbar(@Nonnull PageElement container) {
        super(container);
    }

    public void clickAddFileComment() {
        this.addFileComment.click();
    }

    public ChangeType getChangeType() {
        String changeTypeStr = this.changeTypeLozenge.getText().toUpperCase();
        return ChangeType.valueOf(changeTypeStr);
    }

    public String getFileName() {
        return this.fileName.getText();
    }

    public String getFilePath() {
        return this.filePath.getText();
    }

    public String getFileReportsButtonLabel() {
        Poller.waitUntilTrue((TimedQuery)this.fileReportsButton.timed().isVisible());
        return this.fileReportsButton.getAttribute("aria-label");
    }

    public String getSourceLinkUrl() {
        return this.viewSourceLink.getAttribute("href");
    }

    public boolean hasCodeInsightsOptions() {
        this.openDiffOptions();
        boolean hasCodeInsightsOptions = this.showAnnotationsRadio.isPresent() || this.showCodeCoverageRadio.isPresent();
        this.closeDiffOptions();
        return hasCodeInsightsOptions;
    }

    public boolean hasCommentOptions() {
        this.openDiffOptions();
        boolean hasCommentOptions = this.showCommentsAndTasksRadio.isPresent();
        this.closeDiffOptions();
        return hasCommentOptions;
    }

    public FileReportsDialog openFileReportsDialog() {
        Poller.waitUntilTrue((TimedQuery)this.fileReportsButton.timed().isVisible());
        this.fileReportsButton.click();
        return (FileReportsDialog)this.pageBinder.bind(FileReportsDialog.class, new Object[]{this.fileReportsDialog});
    }

    public void viewSideBySideDiff() {
        this.openDiffOptions();
        this.sideBySideDiffRadio.click();
    }

    public void viewUnifiedDiff() {
        this.openDiffOptions();
        this.unifiedDiffRadio.click();
    }

    private void closeDiffOptions() {
        this.diffOptionsDropdownTrigger.click();
        Poller.waitUntilFalse((TimedQuery)this.diffOptionsDropdownContent.timed().isVisible());
    }

    private void openDiffOptions() {
        this.diffOptionsDropdownTrigger.click();
        Poller.waitUntilTrue((TimedQuery)this.diffOptionsDropdownContent.timed().isVisible());
    }

    public static enum ChangeType {
        ADDED,
        COPIED,
        DELETED,
        MODIFIED,
        MOVED,
        RENAMED;

    }
}

