/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.ratelimit;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.TabItem;
import com.atlassian.webdriver.bitbucket.element.admin.ratelimit.GlobalSettings;
import com.atlassian.webdriver.bitbucket.element.admin.ratelimit.UserExemptions;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import java.util.Collection;
import java.util.Collections;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;

public class RateLimitSettingsPage
extends BitbucketPage {
    @ElementBy(id="rate-limit-settings-container")
    private PageElement container;
    @ElementBy(className="global-settings-form")
    private PageElement globalSettingsForm;
    @ElementBy(className="user-exemptions")
    private PageElement userExemptions;

    public void clickExemptionsTab() {
        this.getTab("Exemptions").click();
    }

    public void clickSettingsTab() {
        this.getTab("Settings & Log").click();
    }

    @WaitUntil
    public void ensurePageIsLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.globalSettingsForm.timed().isVisible());
    }

    public TabItem getActiveTab() {
        for (TabItem tab : this.getTabItems()) {
            Poller.waitUntilTrue((TimedQuery)tab.timed().isVisible());
            if (!tab.getCssClasses().contains("active-tab")) continue;
            return tab;
        }
        throw new NoSuchElementException("No selected tab found");
    }

    public GlobalSettings getGlobalSettings() {
        return (GlobalSettings)this.pageBinder.bind(GlobalSettings.class, new Object[]{this.globalSettingsForm});
    }

    public UserExemptions getUserExemptions() {
        return (UserExemptions)this.pageBinder.bind(UserExemptions.class, new Object[]{this.userExemptions});
    }

    public String getUrl() {
        return "/admin/rate-limit";
    }

    private TabItem getTab(String text) {
        for (TabItem tab : this.getTabItems()) {
            if (!tab.getText().trim().equalsIgnoreCase(text.trim())) continue;
            return tab;
        }
        throw new NoSuchElementException(text + " tab not found");
    }

    private Collection<TabItem> getTabItems() {
        try {
            return this.elementFinder.findAll(By.cssSelector((String)".aui-tabs > .tabs-menu > li"), TabItem.class, TimeoutType.PAGE_LOAD);
        }
        catch (NoSuchElementException e) {
            return Collections.emptyList();
        }
    }
}

