/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.hooks;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.hooks.RepositoryHookRow;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class RepositoryHooksPage
extends BaseSidebarPage {
    private final Class<RepositoryHookRow> rowClass;
    private final String url;

    public RepositoryHooksPage(String url, Class<RepositoryHookRow> rowClass) {
        this.url = url;
        this.rowClass = rowClass;
    }

    @Override
    public void doWait() {
        super.doWait();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"footer-body")).timed().isPresent());
    }

    public PageElement getDescription() {
        return this.elementFinder.find(By.cssSelector((String)".aui-page-header + p"));
    }

    public RepositoryHookRow getHook(String hookName) {
        List<RepositoryHookRow> hooks = this.getHooks();
        return hooks.stream().filter(row -> hookName.equals(row.getName())).findFirst().orElseThrow(() -> {
            String availableHooks = String.join((CharSequence)", ", hooks.stream().map(RepositoryHookRow::getName).collect(Collectors.toList()));
            return new AssertionError((Object)("Could not find hook with name '" + hookName + "'. Available hooks: " + availableHooks));
        });
    }

    public List<RepositoryHookRow> getHooks(By selector) {
        return this.elementFinder.findAll(selector).stream().map(row -> (RepositoryHookRow)this.pageBinder.bind(this.rowClass, new Object[]{row, this})).collect(Collectors.toList());
    }

    public List<RepositoryHookRow> getHooks() {
        return this.getHooks(By.cssSelector((String)".hooks-table tbody tr"));
    }

    public Optional<PageElement> getProjectLink() {
        return this.getDescription().findAll(By.tagName((String)"a")).stream().filter(link -> "project settings".equals(link.getText())).findFirst();
    }

    public String getUrl() {
        return this.url;
    }

    public void loadMore() {
        this.elementFinder.find(By.cssSelector((String)".more-container button")).click();
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.cssSelector((String)"aui-spinner")).timed().isVisible());
    }
}

