/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.UserAccountGpgKeyRow;
import com.atlassian.webdriver.bitbucket.page.UserAccountAddGpgKeyPage;
import com.atlassian.webdriver.bitbucket.page.UserAccountSettingsPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import java.util.List;
import java.util.stream.Collectors;

public class UserAccountGpgSettingsPage
extends UserAccountSettingsPage {
    @ElementBy(id="gpg-add-key-button")
    private PageElement addKeyButton;
    @ElementBy(id="gpg-keys-table")
    private PageElement gpgKeysTable;
    @ElementBy(className="confirm-button")
    private PageElement confirmButton;

    @Init
    public void init() {
        ElementUtils.displayAllDeleteButtons(this.javascriptExecutor);
    }

    @Override
    public String getUrl() {
        return "/plugins/servlet/gpg/keys";
    }

    public List<UserAccountGpgKeyRow> getGpgKeys() {
        return this.gpgKeysTable.findAll(Locators.tableRow()).stream().map(pageElement -> (UserAccountGpgKeyRow)this.pageBinder.bind(UserAccountGpgKeyRow.class, new Object[]{pageElement})).collect(Collectors.toList());
    }

    public UserAccountAddGpgKeyPage clickAddKey() {
        this.waitForPageLoad(() -> this.addKeyButton.click());
        return (UserAccountAddGpgKeyPage)this.pageBinder.bind(UserAccountAddGpgKeyPage.class, new Object[0]);
    }

    public UserAccountGpgSettingsPage clickConfirmButton() {
        Poller.waitUntilTrue((String)"Confirm button not found", (TimedQuery)this.confirmButton.timed().isPresent());
        this.confirmButton.click();
        return (UserAccountGpgSettingsPage)this.pageBinder.bind(UserAccountGpgSettingsPage.class, new Object[0]);
    }
}

