/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketLoginPage;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import java.util.List;

public class SignUpPage
extends BitbucketPage {
    @ElementBy(cssSelector="#content form")
    private PageElement parentForm;
    @ElementBy(id="username")
    private PageElement username;
    @ElementBy(id="password")
    private PageElement password;
    @ElementBy(id="confirmPassword")
    private PageElement confirmPassword;
    @ElementBy(id="fullname")
    private PageElement fullname;
    @ElementBy(id="email")
    private PageElement email;
    @ElementBy(id="captcha")
    private PageElement captcha;
    @ElementBy(id="captcha-image")
    private PageElement captchaImage;
    @ElementBy(id="captcha-reload")
    private PageElement captchaReloadButton;
    @ElementBy(id="submit")
    private PageElement signUpButton;
    @ElementBy(id="cancel")
    private PageElement cancelLink;

    public String getUrl() {
        return "/signup";
    }

    public SignUpPage setUsername(String username) {
        return this.setField(this.username, username);
    }

    public SignUpPage setPassword(String password) {
        return this.setField(this.password, password);
    }

    public SignUpPage setConfirmPassword(String confirmPassword) {
        return this.setField(this.confirmPassword, confirmPassword);
    }

    public SignUpPage setFullname(String fullname) {
        return this.setField(this.fullname, fullname);
    }

    public SignUpPage setEmail(String email) {
        return this.setField(this.email, email);
    }

    public SignUpPage setCaptcha(String captcha) {
        return this.setField(this.captcha, captcha);
    }

    private SignUpPage setField(PageElement field, String value) {
        field.clear().type(new CharSequence[]{value});
        return this;
    }

    public String getCaptchImageSrc() {
        return this.captchaImage.getAttribute("src");
    }

    public void clickCaptchaReload() {
        this.captchaReloadButton.click();
    }

    public boolean isSubmitDisabled() {
        return this.signUpButton.hasAttribute("disabled", "true") && this.signUpButton.hasClass("disabled");
    }

    public BitbucketLoginPage submitSuccess() {
        this.signUpButton.click();
        return (BitbucketLoginPage)this.pageBinder.bind(BitbucketLoginPage.class, new Object[0]);
    }

    public SignUpPage submitFail() {
        this.signUpButton.click();
        return (SignUpPage)this.pageBinder.bind(SignUpPage.class, new Object[0]);
    }

    public BitbucketLoginPage cancel() {
        this.cancelLink.click();
        return (BitbucketLoginPage)this.pageBinder.bind(BitbucketLoginPage.class, new Object[0]);
    }

    public List<String> getFieldsWithErrors() {
        return this.getFieldsWithErrors(this.parentForm);
    }
}

