/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementActions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.BitbucketHeader;
import com.atlassian.webdriver.bitbucket.element.ErrorDialog;
import com.atlassian.webdriver.bitbucket.page.AbstractPage;
import com.atlassian.webdriver.bitbucket.page.LogoutPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;

public abstract class BitbucketPage
extends AbstractPage {
    @ElementBy(id="content")
    protected PageElement content;
    @ElementBy(id="footer")
    protected PageElement footer;
    @Inject
    protected PageElementActions actions;
    @ElementBy(id="header")
    private PageElement header;

    public void assertIsError(String expectedMessage, int expectedError) {
        if (expectedError == Response.Status.UNAUTHORIZED.getStatusCode() || expectedError == Response.Status.NOT_FOUND.getStatusCode() || expectedError == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            PageElement errorImage = this.content.find(By.className((String)"error-image"));
            Assert.assertTrue((String)"Error image not present", (boolean)errorImage.isPresent());
            Assert.assertTrue((String)("Error image does not have expected class _" + expectedError), (boolean)errorImage.hasClass("_" + expectedError));
            Assert.assertThat((Object)this.content.getText(), (Matcher)Matchers.containsString((String)expectedMessage));
        } else {
            Assert.assertThat((Object)this.elementFinder.find(By.tagName((String)"h1")).getText(), (Matcher)Matchers.containsString((String)String.valueOf(expectedError)));
            if (expectedMessage != null) {
                Assert.assertThat((Object)this.elementFinder.find(By.tagName((String)"body")).getText(), (Matcher)Matchers.containsString((String)expectedMessage));
            }
        }
    }

    public Collection<String> getAlerts() {
        PageElement alertsTrigger = this.header.find(By.id((String)"alerts-trigger"));
        alertsTrigger.click();
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#inline-dialog-alerts-content aui-spinner")).timed().isPresent());
        return ElementUtils.getElementTexts(this.body.findAll(By.cssSelector((String)".alerts-list .aui-message")));
    }

    public Collection<String> getAuiBannerMessages() {
        return ElementUtils.getElementTexts(this.body.findAll(By.className((String)"aui-banner")));
    }

    public Collection<String> getAuiMessages() {
        List errors = this.body.findAll(By.className((String)"aui-message"), TimeoutType.DEFAULT);
        return ElementUtils.getElementTexts(errors);
    }

    public Collection<String> getAuiErrorMessages() {
        List errors = this.body.findAll(By.className((String)"aui-message-error"), TimeoutType.DEFAULT);
        return ElementUtils.getElementTexts(errors);
    }

    public Collection<String> getAuiFlagErrorMessages() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"aui-flag")).timed().isVisible());
        return this.getAuiErrorMessages();
    }

    public Collection<String> getAuiSuccessMessages() {
        return ElementUtils.getElementTexts(this.body.findAll(By.className((String)"aui-message-success")));
    }

    public Collection<String> getAuiWarningMessages() {
        return ElementUtils.getElementTexts(this.body.findAll(By.className((String)"aui-message-warning")));
    }

    public String getDocumentationLink() {
        return this.driver.findElement(By.id((String)"com.atlassian.bitbucket.server.bitbucket-server-web-fragments-help-menu")).findElement(By.tagName((String)"a")).getAttribute("href");
    }

    public void closeFlags() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)".aui-flag > .aui-message")).timed().isVisible());
        this.doCloseFlags();
    }

    public void closeFlagsIfVisible() {
        if (this.elementFinder.find(By.cssSelector((String)".aui-flag > .aui-message")).isVisible()) {
            this.doCloseFlags();
        }
    }

    private void doCloseFlags() {
        try {
            this.elementFinder.findAll(By.cssSelector((String)".aui-flag > .aui-message > .icon-close")).forEach(close -> this.actions.moveToElement(close).click().perform());
        }
        catch (MoveTargetOutOfBoundsException moveTargetOutOfBoundsException) {
            // empty catch block
        }
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.className((String)"aui-message")).timed().isVisible());
    }

    public ErrorDialog getErrorDialog() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"error-dialog")).timed().isVisible());
        return (ErrorDialog)((Object)this.body.findAll(By.className((String)"error-dialog"), ErrorDialog.class).get(0));
    }

    public List<String> getFieldsWithErrors(PageElement form) {
        return Lists.newArrayList(ElementUtils.getFieldsWithErrors(form));
    }

    public BitbucketHeader getHeader() {
        return (BitbucketHeader)this.pageBinder.bind(BitbucketHeader.class, new Object[]{this.header});
    }

    public boolean hasAdminLink() {
        return this.header.find(By.cssSelector((String)"a.admin-link")).isPresent();
    }

    public TimedCondition isPermissionDenied() {
        return this.elementFinder.find(By.className((String)"_401")).timed().isPresent();
    }

    public LogoutPage logout() {
        return this.getHeader().logout(LogoutPage.class);
    }

    @Override
    public void scrollToTop() {
        super.scrollToTop();
        Poller.waitUntilTrue((TimedQuery)this.header.find(By.id((String)"logo")).timed().isVisible());
    }

    protected void useShortcut(CharSequence key) {
        this.body.type(new CharSequence[]{key});
    }
}

