/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.ProjectSidebarNav;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.ProjectEditSettingsPage;
import com.atlassian.webdriver.bitbucket.page.ProjectOverviewPage;
import org.openqa.selenium.By;

public abstract class BaseProjectPage
extends BaseSidebarPage {
    @ElementBy(cssSelector="#content > .aui-sidebar", pageElementClass=ProjectSidebarNav.class)
    private ProjectSidebarNav sidebarNav;
    private final String key;
    private String name;

    public BaseProjectPage(String key) {
        this.key = key;
    }

    public String getProjectKey() {
        return this.key;
    }

    public String getProjectName() {
        if (this.name == null) {
            this.name = this.elementFinder.find(By.cssSelector((String)"header a.entity-name")).getText();
        }
        return this.name;
    }

    public ProjectSidebarNav getSidebarNav() {
        return this.sidebarNav;
    }

    public ProjectEditSettingsPage goToEditSettingsPage() {
        this.sidebarNav.clickSettingsItem();
        return (ProjectEditSettingsPage)this.pageBinder.bind(ProjectEditSettingsPage.class, new Object[]{this.key});
    }

    public ProjectOverviewPage goToOverviewPage() {
        this.sidebarNav.clickRepositoriesItem();
        return (ProjectOverviewPage)this.pageBinder.bind(ProjectOverviewPage.class, new Object[]{this.key});
    }

    @Override
    public void doWait() {
        super.doWait();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"footer-body")).timed().isPresent());
    }
}

