/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.hamcrest;

import com.atlassian.webdriver.bitbucket.element.IdOption;
import com.atlassian.webdriver.bitbucket.element.UserOption;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class OptionMatchers {
    private OptionMatchers() {
        throw new UnsupportedOperationException("Do not instantiate " + this.getClass().getSimpleName());
    }

    @Nonnull
    public static Matcher<IdOption> withId(@Nullable String expectedId) {
        return OptionMatchers.withIdThat((Matcher<String>)Matchers.is((Object)expectedId));
    }

    @Nonnull
    public static Matcher<IdOption> withIdThat(@Nonnull Matcher<String> idMatcher) {
        Preconditions.checkNotNull(idMatcher, (Object)"idMatcher");
        return new FeatureMatcher<IdOption, String>(idMatcher, "ID that", "id"){

            protected String featureValueOf(IdOption actual) {
                return actual.getId();
            }
        };
    }

    @Nonnull
    public static Matcher<UserOption> withUsername(@Nonnull String expectedUsername) {
        Preconditions.checkNotNull((Object)expectedUsername, (Object)"expectedUsername");
        return OptionMatchers.withUsernameThat((Matcher<String>)Matchers.is((Object)expectedUsername));
    }

    @Nonnull
    public static Matcher<UserOption> withUsernameThat(@Nonnull Matcher<String> usernameMatcher) {
        Preconditions.checkNotNull(usernameMatcher, (Object)"usernameMatcher");
        return new FeatureMatcher<UserOption, String>(usernameMatcher, "username that", "username"){

            protected String featureValueOf(UserOption actual) {
                return actual.getUsername();
            }
        };
    }
}

