/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.admin.ratelimit;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;

public class GlobalSettings
extends AbstractElementPageObject {
    @ElementBy(cssSelector=".buttons-container .buttons .cancel-button")
    private PageElement cancelButton;
    @ElementBy(id="capacity")
    private PageElement capacity;
    @ElementBy(cssSelector="#capacity ~ p.error")
    private PageElement capacityError;
    @ElementBy(id="fillRate")
    private PageElement fillRate;
    @ElementBy(cssSelector="#fillRate ~ p.error")
    private PageElement fillRateError;
    @ElementBy(id="rate-limiting-disable")
    private PageElement rateLimitingEnabledOff;
    @ElementBy(id="rate-limiting-enable")
    private PageElement rateLimitingEnabledOn;
    @ElementBy(cssSelector=".buttons-container .buttons .save-button")
    private PageElement saveButton;

    public GlobalSettings(PageElement container) {
        super(container);
    }

    public GlobalSettings clickCancel() {
        this.cancelButton.click();
        return this;
    }

    public GlobalSettings clickSave() {
        this.saveButton.click();
        return this;
    }

    public GlobalSettings disableRateLimiting() {
        this.rateLimitingEnabledOff.click();
        return this;
    }

    public GlobalSettings enabledRateLimiting() {
        this.rateLimitingEnabledOn.click();
        return this;
    }

    public TimedQuery<String> getCapacity() {
        return this.capacity.timed().getValue();
    }

    public TimedQuery<String> getCapacityError() {
        return this.capacityError.timed().getText();
    }

    public TimedQuery<String> getFillRate() {
        return this.fillRate.timed().getValue();
    }

    public TimedQuery<String> getFillRateError() {
        return this.fillRateError.timed().getText();
    }

    public TimedCondition isCancelButtonEnabled() {
        return this.cancelButton.timed().isEnabled();
    }

    public TimedCondition isCapacityEnabled() {
        return this.capacity.timed().isEnabled();
    }

    public TimedCondition isFillRateEnabled() {
        return this.fillRate.timed().isEnabled();
    }

    public TimedCondition isRateLimitingEnabled() {
        return this.rateLimitingEnabledOn.timed().isSelected();
    }

    public TimedCondition isSaveButtonEnabled() {
        return this.saveButton.timed().isEnabled();
    }

    public TimedCondition isVisible() {
        return this.container.timed().isVisible();
    }

    public GlobalSettings setCapacity(String value) {
        this.capacity.clear().type(new CharSequence[]{value});
        return this;
    }

    public GlobalSettings setFillRate(String value) {
        this.fillRate.clear().type(new CharSequence[]{value});
        return this;
    }
}

