/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.utils.by.ByDataAttribute;
import com.google.common.base.Preconditions;
import org.openqa.selenium.By;

public class SearchableSelectorDialog {
    private final PageElement dialog;

    public SearchableSelectorDialog(PageElement dialog) {
        this.dialog = (PageElement)Preconditions.checkNotNull((Object)dialog, (Object)"dialog");
    }

    public SearchableSelectorDialog filterBy(final String filterText) {
        final PageElement filterInput = this.dialog.find(By.className((String)"filter"));
        Preconditions.checkState((boolean)filterInput.isPresent(), (Object)"Searchable selector is not filterable");
        ElementUtils.waitUntilUpdated(this.getResultsList(), new Runnable(){

            @Override
            public void run() {
                filterInput.type(new CharSequence[]{filterText});
            }
        });
        return this;
    }

    public TimedCondition isLoadingPage() {
        return this.dialog.find(By.className((String)"spinner-wrapper")).timed().isVisible();
    }

    public TimedCondition isOpen() {
        return this.dialog.timed().isVisible();
    }

    public boolean hasTabs() {
        return this.dialog.find(By.className((String)"tabs-menu")).isPresent();
    }

    public int numberOfResults() {
        return this.getResultsList().findAll(By.className((String)"result")).size();
    }

    public PageElement getResultsList() {
        String resultListSelector = this.hasTabs() ? ".active-pane .results-list" : ".results-list";
        return this.dialog.find(By.cssSelector((String)resultListSelector));
    }

    public void selectItemByName(String itemName) {
        this.dialog.find(By.partialLinkText((String)itemName)).click();
        Poller.waitUntilFalse((TimedQuery)this.dialog.timed().isVisible());
    }

    public void selectItemByExactName(String itemName) {
        this.dialog.find(By.linkText((String)itemName)).click();
        Poller.waitUntilFalse((TimedQuery)this.dialog.timed().isVisible());
    }

    public void selectItemById(String dataId) {
        PageElement item = this.dialog.find(By.className((String)"results")).find(ByDataAttribute.byData((String)"id", (String)dataId));
        Poller.waitUntilTrue((TimedQuery)item.timed().isVisible());
        item.javascript().form().focus();
        item.click();
        Poller.waitUntilFalse((TimedQuery)this.dialog.timed().isVisible());
    }

    public SearchableSelectorDialog selectBranches() {
        return this.selectTab("Branches");
    }

    public SearchableSelectorDialog selectTags() {
        return this.selectTab("Tags");
    }

    public SearchableSelectorDialog selectCommits() {
        return this.selectTab("Commits");
    }

    private SearchableSelectorDialog selectTab(String linkText) {
        PageElement tab = this.dialog.find(By.linkText((String)linkText)).click();
        Poller.waitUntilTrue((TimedQuery)tab.timed().hasAttribute("aria-selected", "true"));
        return this;
    }
}

