/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.RepositoryTable;
import com.atlassian.webdriver.bitbucket.page.FileBrowserPage;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class ProjectRepositoryTable
extends RepositoryTable<ProjectRepositoryRow> {
    private final String projectKey;

    public ProjectRepositoryTable(@Nonnull PageElement pageElement, @Nonnull String projectKey) {
        super(pageElement, ProjectRepositoryRow.class);
        this.projectKey = (String)Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey");
    }

    public ProjectRepositoryTable(By locator, TimeoutType timeoutType, String projectKey) {
        super(locator, timeoutType);
        this.projectKey = (String)Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey");
    }

    @Override
    public ProjectRepositoryRow scrollToRepository(String repositoryName) {
        return ((ProjectRepositoryRow)((Object)super.scrollToRepository(repositoryName))).setProjectKey(this.projectKey);
    }

    @Override
    public ProjectRepositoryRow findRepositoryByName(String repositoryName) {
        ProjectRepositoryRow row = (ProjectRepositoryRow)((Object)super.findRepositoryByName(repositoryName));
        return row != null ? row.setProjectKey(this.projectKey) : null;
    }

    @Override
    public List<ProjectRepositoryRow> getRepositories() {
        return Lists.transform(super.getRepositories(), (Function)new Function<ProjectRepositoryRow, ProjectRepositoryRow>(){

            public ProjectRepositoryRow apply(ProjectRepositoryRow row) {
                return row.setProjectKey(ProjectRepositoryTable.this.projectKey);
            }
        });
    }

    public static class ProjectRepositoryRow
    extends RepositoryTable.RepositoryRow {
        private String projectKey;

        public ProjectRepositoryRow(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public ProjectRepositoryRow(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        private ProjectRepositoryRow setProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public FileBrowserPage goToRepositoryPage() {
            String slug = this.getRepositorySlug();
            this.getNameColumn().find(By.tagName((String)"a")).click();
            return (FileBrowserPage)this.pageBinder.bind(FileBrowserPage.class, new Object[]{this.projectKey, slug});
        }
    }
}

