/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repo;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.Avatar;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.util.DateUtils;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;

public class AuditPage
extends BaseRepositoryPage {
    private static final String AUDIT_TABLE_CLASS = "audit-log-table";

    public AuditPage(String projectKey, String repositorySlug) {
        super(projectKey, repositorySlug);
    }

    public String getUrl() {
        return String.format("/plugins/servlet/audit-log/%s/%s", this.projectKey, this.slug);
    }

    public boolean isEmpty() {
        return this.elementFinder.find(By.className((String)"audit-log-empty")).isPresent();
    }

    public List<AuditRow> getEntries() {
        return this.getHooks(By.cssSelector((String)".audit-log-table tbody tr"));
    }

    private List<AuditRow> getHooks(By selector) {
        return Lists.newArrayList((Iterable)Lists.transform((List)this.elementFinder.findAll(selector), (Function)new Function<PageElement, AuditRow>(){

            public AuditRow apply(PageElement row) {
                return (AuditRow)AuditPage.this.pageBinder.bind(AuditRow.class, new Object[]{row});
            }
        }));
    }

    public void scroll() {
        ElementUtils.scrollDocumentAndWait(this.elementFinder.find(By.className((String)AUDIT_TABLE_CLASS)));
    }

    public void scrollUntilNoMoreResults() {
        Poller.waitUntil((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<PageElement>(){

            public PageElement get() {
                AuditPage.this.scroll();
                return AuditPage.this.elementFinder.find(By.className((String)"no-more-results"), PageElement.class);
            }
        }), (Matcher)Matchers.notNullValue(PageElement.class));
    }

    public static class AuditRow {
        private final PageElement element;

        public AuditRow(PageElement element) {
            this.element = element;
        }

        public Avatar getUser() {
            return (Avatar)this.element.find(By.className((String)"cell-username")).find(By.className((String)"user-avatar"), Avatar.class);
        }

        public String getAction() {
            return this.element.find(By.className((String)"cell-action")).getText();
        }

        public String getDetails() {
            return this.element.find(By.className((String)"cell-details")).getText();
        }

        public Instant getTimestamp() {
            return DateUtils.parseServerTimestamp(this.element.find(By.className((String)"cell-timestamp")).getAttribute("datetime")).toInstant();
        }

        private void click() {
            this.element.click();
        }
    }
}

