/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.accesstokens;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import java.util.Locale;
import org.openqa.selenium.By;

public class PermissionHelper {
    private PermissionHelper() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " should not be instantiated");
    }

    public static void selectPermission(PageElementFinder elementFinder, Permission permission) {
        String optionSelector = "label[for=\"select-%s-permission\"] + .permission-select";
        String valueSelector = " #react-select-%s--option-";
        if (permission.isResource(Project.class)) {
            optionSelector = String.format(optionSelector, "project");
            valueSelector = String.format(valueSelector, "2");
        } else if (permission.isResource(Repository.class)) {
            optionSelector = String.format(optionSelector, "repository");
            valueSelector = String.format(valueSelector, "3");
        } else {
            throw new IllegalArgumentException("Permission must be either Repo or Project type permissions");
        }
        valueSelector = permission == Permission.PROJECT_ADMIN || permission == Permission.REPO_ADMIN ? valueSelector + "0" : (permission == Permission.PROJECT_WRITE || permission == Permission.REPO_WRITE ? valueSelector + "1" : valueSelector + "2");
        elementFinder.find(By.cssSelector((String)optionSelector)).click();
        PageElement permissionValue = elementFinder.find(By.cssSelector((String)(optionSelector + valueSelector)));
        Poller.waitUntilTrue((TimedQuery)permissionValue.timed().isVisible());
        permissionValue.select();
    }

    public static Permission repoPermissionFromString(String permission) {
        switch (permission.toLowerCase(Locale.US)) {
            case "admin": {
                return Permission.REPO_ADMIN;
            }
            case "write": {
                return Permission.REPO_WRITE;
            }
            case "read": {
                return Permission.REPO_READ;
            }
        }
        throw new IllegalArgumentException("Repo permission must be one of: read, write, admin");
    }

    public static Permission projectPermissionFromString(String permission) {
        switch (permission.toLowerCase(Locale.ENGLISH)) {
            case "admin": {
                return Permission.PROJECT_ADMIN;
            }
            case "write": {
                return Permission.PROJECT_WRITE;
            }
            case "read": {
                return Permission.PROJECT_READ;
            }
        }
        throw new IllegalArgumentException("Project permission must be one of: read, write, admin");
    }
}

