/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.codeinsights;

import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class CodeInsightsOverviewReportMenuItem
extends AbstractElementPageObject {
    public CodeInsightsOverviewReportMenuItem(@Nonnull PageElement container) {
        super(container);
    }

    public String getLogoUrl() {
        return this.find(By.tagName((String)"img")).getAttribute("src");
    }

    public InsightResult getResult() {
        String text = this.getResultElement().getText();
        if ("PASSED".equals(text)) {
            return InsightResult.PASS;
        }
        if ("FAILED".equals(text)) {
            return InsightResult.FAIL;
        }
        throw new AssertionError((Object)("Expected result to be one of [PASSED, FAILED] but it was " + text));
    }

    public String getTitle() {
        return this.find(By.className((String)"title")).getText();
    }

    public boolean hasDefaultLogo() {
        return this.findAll(By.className((String)"aui-iconfont-addon")).iterator().hasNext();
    }

    public boolean hasResult() {
        return this.getResultElement().isPresent();
    }

    private PageElement getResultElement() {
        return this.find(By.className((String)"aui-lozenge"));
    }
}

