/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.codeinsights;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.codeinsights.CodeInsightsOverviewAnnotation;
import com.atlassian.webdriver.bitbucket.element.codeinsights.CodeInsightsOverviewDialog;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class CodeInsightsOverviewReport
extends AbstractElementPageObject {
    private final CodeInsightsOverviewDialog parent;

    public CodeInsightsOverviewReport(@Nonnull PageElement container, @Nonnull CodeInsightsOverviewDialog parent) {
        super(container);
        this.parent = parent;
    }

    public List<CodeInsightsOverviewAnnotation> getAnnotations() {
        PageElement tableBody = this.find(By.className((String)"report-annotation-table")).find(By.tagName((String)"tbody"));
        Poller.waitUntilTrue((TimedQuery)tableBody.timed().isVisible());
        return tableBody.findAll(By.tagName((String)"tr")).stream().map(row -> (CodeInsightsOverviewAnnotation)this.pageBinder.bind(CodeInsightsOverviewAnnotation.class, new Object[]{row, this})).collect(Collectors.toList());
    }

    public Map<String, PageElement> getCustomData() {
        PageElement pageElement = this.find(By.className((String)"report-custom-data"));
        List dt = pageElement.findAll(By.tagName((String)"dt"));
        List dd = pageElement.findAll(By.tagName((String)"dd"));
        return IntStream.range(0, dt.size()).boxed().collect(Collectors.toMap(i -> ((PageElement)dt.get((int)i)).getText(), dd::get));
    }

    public String getDetails() {
        return this.find(By.tagName((String)"p")).getText();
    }

    public String getProjectKey() {
        return this.parent.getProjectKey();
    }

    public long getPullRequestId() {
        return this.parent.getPullRequestId();
    }

    public String getSlug() {
        return this.parent.getSlug();
    }

    public String getTitle() {
        return this.find(By.tagName((String)"h1")).getText();
    }

    public boolean hasAnnotations() {
        return (Boolean)this.find(By.className((String)"report-annotation-table")).timed().isPresent().byDefaultTimeout();
    }
}

