/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.activity;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class ToolbarButton<T>
extends LegacyElementPageObject {
    private final BitbucketPage currentPage;
    private final Supplier<T> returnElement;

    public ToolbarButton(@Nonnull PageElement container, @Nonnull BitbucketPage currentPage, @Nonnull Supplier<T> returnElement) {
        super(container);
        this.currentPage = (BitbucketPage)Preconditions.checkNotNull((Object)currentPage, (Object)"currentPage");
        this.returnElement = (Supplier)Preconditions.checkNotNull(returnElement, (Object)"returnElement");
    }

    public ToolbarButton(By locatable, TimeoutType timeoutType, BitbucketPage currentPage, Supplier<T> returnElement) {
        super(locatable, timeoutType);
        this.returnElement = returnElement;
        this.currentPage = currentPage;
    }

    public T clickButton() {
        Poller.waitUntilFalse((TimedQuery)this.withTimeout(TimeoutType.DEFAULT).timed().hasAttribute("aria-disabled", "true"));
        this.click();
        return (T)this.returnElement.get();
    }

    public T clickButtonAndWaitForReload() {
        return this.currentPage.waitForPageLoad(() -> {
            this.click();
            return this.returnElement.get();
        });
    }

    public boolean isEnabled() {
        return this.isPresent() && (Boolean)this.withTimeout(TimeoutType.DEFAULT).timed().hasAttribute("aria-disabled", "true").byDefaultTimeout() == false;
    }
}

