/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.notification.PullRequestNotificationScope;
import com.atlassian.webdriver.bitbucket.element.notification.PushNotificationScope;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RepositoryNotificationSettingsDialog
extends AbstractElementPageObject {
    @ElementBy(cssSelector=".aui-dialog2-footer-actions .aui-button-link")
    private PageElement cancelButton;
    @ElementBy(cssSelector=".aui-dialog2-footer-actions .aui-button-primary")
    private PageElement saveButton;

    public RepositoryNotificationSettingsDialog(@Nonnull PageElement container) {
        super(container);
    }

    public void clickCancel() {
        this.cancelButton.click();
        Poller.waitUntilFalse((String)"The repository notification settings dialog should be closed", (TimedQuery)Conditions.forSupplier((long)5000L, () -> ((PageElement)this.container).isPresent()));
    }

    public void clickSave() {
        this.saveButton.click();
        Poller.waitUntilFalse((String)"The repository notification settings dialog should be closed", (TimedQuery)Conditions.forSupplier((long)5000L, () -> ((PageElement)this.container).isPresent()));
    }

    public PullRequestNotificationScope getPullRequestNotificationScope() {
        return this.container.findAll(By.cssSelector((String)"input.radio[id^='pr-']")).stream().filter(PageElement::isSelected).map(PageElement::getId).map(PullRequestNotificationScope::fromElementId).findFirst().orElseThrow(() -> new IllegalStateException("A pull request notification scope should be selected"));
    }

    public PushNotificationScope getPushNotificationScope() {
        return this.container.findAll(By.cssSelector((String)"input.radio[id^='commits-']")).stream().filter(PageElement::isSelected).map(PageElement::getId).map(PushNotificationScope::fromElementId).findFirst().orElseThrow(() -> new IllegalStateException("A push notification scope should be selected"));
    }

    public RepositoryNotificationSettingsDialog setPullRequestNotificationScope(PullRequestNotificationScope scope) {
        this.container.find(By.cssSelector((String)("input.radio#" + scope.getElementId()))).click();
        return this;
    }

    public RepositoryNotificationSettingsDialog setPushNotificationScope(PushNotificationScope scope) {
        this.container.find(By.cssSelector((String)("input.radio#" + scope.getElementId()))).click();
        return this;
    }
}

