/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.TabItem;
import java.util.Collection;
import java.util.Collections;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;

public class PullRequestTabs
extends LegacyElementPageObject {
    public PullRequestTabs(PageElement pageElement) {
        super(pageElement);
    }

    public PullRequestTabs(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public Collection<TabItem> getTabItems() {
        try {
            return this.findAll(By.cssSelector((String)".aui-tabs > .tabs-menu > li"), TabItem.class, TimeoutType.PAGE_LOAD);
        }
        catch (NoSuchElementException e) {
            return Collections.emptyList();
        }
    }

    public TabItem getTab(String text) {
        for (TabItem tab : this.getTabItems()) {
            Poller.waitUntilTrue((TimedQuery)tab.timed().isVisible());
            if (!tab.getText().trim().equalsIgnoreCase(text.trim())) continue;
            return tab;
        }
        throw new NoSuchElementException(text + " tab not found");
    }

    public void clickOverviewTab() {
        this.getTab("Overview").click();
    }

    public void clickDiffTab() {
        this.getTab("Diff").click();
    }

    public void clickCommitsTab() {
        this.getTab("Commits").click();
    }
}

