/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorsAdminPage;
import org.openqa.selenium.By;

public class MirrorConfigPage
extends MirrorsAdminPage {
    private static final String PROJECT_SELECTOR_ID = "s2id_autogen1";
    @ElementBy(cssSelector="#mirror-details-panel iframe")
    private PageElement connectIFrame;
    @ElementBy(id="mirror-remove-button")
    private PageElement deleteButton;

    @WaitUntil
    public void ensurePageAndIFrameLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.deleteButton.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
        Poller.waitUntilTrue((TimedQuery)this.connectIFrame.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
        this.inConnectFrame(() -> {
            PageElement projectSelector = this.elementFinder.find(By.id((String)PROJECT_SELECTOR_ID));
            Poller.waitUntilTrue((TimedQuery)projectSelector.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
        });
    }

    public void addProject(String projectName) {
        this.inConnectFrame(() -> {
            PageElement projectSelector = this.elementFinder.find(By.id((String)PROJECT_SELECTOR_ID));
            PageElement addButton = this.elementFinder.find(By.cssSelector((String)"button.project-selector-add"));
            PageElement autoCompleteResult = this.elementFinder.find(By.cssSelector((String)(".select2-results span[title='" + projectName + "']")));
            projectSelector.clear().type(new CharSequence[]{projectName});
            Poller.waitUntilTrue((TimedQuery)autoCompleteResult.withTimeout(TimeoutType.AJAX_ACTION).timed().isPresent());
            autoCompleteResult.click();
            addButton.click();
            PageElement projectRow = this.elementFinder.find(By.cssSelector((String)("td.project-name a[title='" + projectName + "']")));
            Poller.waitUntilTrue((TimedQuery)projectRow.timed().isVisible());
            PageElement progressBar = this.elementFinder.find(By.className((String)"mirror-sync-progress"));
            Poller.waitUntilTrue((TimedQuery)progressBar.timed().isVisible());
            Poller.waitUntilFalse((TimedQuery)progressBar.withTimeout(TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
        });
    }

    public void delete() {
        this.deleteButton.click();
        this.elementFinder.find(By.id((String)"dialog-delete-button")).click();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"aui-message-success")).timed().isVisible());
    }

    private void inConnectFrame(Runnable runnable) {
        this.driver.switchTo().frame(this.connectIFrame.getId());
        try {
            runnable.run();
        }
        finally {
            this.driver.switchTo().defaultContent();
        }
    }
}

