/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AUIDropdown2;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.BranchCreationPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import org.openqa.selenium.By;

public abstract class BranchLayoutPage
extends BaseRepositoryPage {
    @ElementBy(id="repository-layout-revision-selector")
    private PageElement branchSelectorTrigger;
    @ElementBy(id="branch-actions")
    private PageElement branchActionsTrigger;

    public BranchLayoutPage(String projectKey, String slug) {
        super(projectKey, slug);
    }

    public SearchableSelector getBranchSelector() {
        return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.branchSelectorTrigger, By.id((String)"inline-dialog-repository-layout-revision-selector-dialog")});
    }

    public PageElement getBranchAction(String itemName) {
        return this.getBranchActions().open().findItem(itemName);
    }

    public AUIDropdown2 getBranchActions() {
        ElementUtils.disableZeroClipboard(this.javascriptExecutor);
        return (AUIDropdown2)this.pageBinder.bind(AUIDropdown2.class, new Object[]{this.branchActionsTrigger});
    }

    public BranchCreationPage goCreateBranchFrom() {
        this.getBranchActions().open().clickItem("Create branch from here");
        return (BranchCreationPage)this.pageBinder.bind(BranchCreationPage.class, new Object[0]);
    }

    public TimedQuery<String> getError() {
        return this.elementFinder.find(By.className((String)"branch-layout-error")).timed().getText();
    }
}

