/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.tasks;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.element.tasks.TaskTable;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class PullRequestTaskListDialog
extends Dialog2 {
    public static final String CLASS = "task-list-dialog";
    @Inject
    PageElementFinder pageElementFinder;

    public PullRequestTaskListDialog() {
        super(By.className((String)CLASS), TimeoutType.DIALOG_LOAD);
    }

    public void close() {
        this.pageElementFinder.find(By.tagName((String)"body")).type(new CharSequence[]{Keys.ESCAPE});
        this.waitUntilDismissed();
        this.waitUntilBlanketHidden();
    }

    public int getTaskCount() {
        return this.getTaskTable().size();
    }

    public boolean isEmpty() {
        PageElement emptyTableMessage = this.find(By.className((String)"paged-table-message"));
        Poller.waitUntilTrue((String)"Task list is empty", (TimedQuery)emptyTableMessage.timed().isVisible());
        return true;
    }

    public TaskTable.Row getRowByCommentId(long id) {
        return this.getTaskTable().getRowByCommentId(id);
    }

    public TaskTable.Row getRowAt(int i) {
        return this.getTaskTable().getRowAt(i);
    }

    private TaskTable getTaskTable() {
        return (TaskTable)((Object)this.pageBinder.bind(TaskTable.class, new Object[0]));
    }

    @WaitUntil
    private void isLoaded() {
        Poller.waitUntilFalse((TimedQuery)this.find(By.className((String)"spinner")).timed().isVisible());
    }
}

