/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class AUISidebar
extends LegacyElementPageObject {
    @Inject
    private PageElementFinder elementFinder;
    @ElementBy(className="aui-sidebar-toggle")
    private PageElement toggle;

    public AUISidebar(PageElement sidebarContainer) {
        super(sidebarContainer);
    }

    public AUISidebar(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public boolean isCollapsed() {
        return this.hasAttribute("aria-expanded", "false");
    }

    public PageElement getActionsMenu() {
        PageElement submenu = this.elementFinder.find(By.className((String)"aui-sidebar-submenu"));
        Poller.waitUntilTrue((TimedQuery)submenu.timed().isVisible());
        return submenu;
    }

    public List<LinkElement> getActionsLinks() {
        return this.elementFinder.findAll(By.cssSelector((String)".aui-sidebar-group-actions .aui-nav-item"), LinkElement.class);
    }

    public AUISidebar toggle() {
        this.toggle.click();
        return this;
    }
}

