/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.webhook;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.webhook.WebhookCreatePage;
import com.atlassian.webdriver.bitbucket.page.webhook.WebhookRow;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class WebhookPage
extends BaseSidebarPage {
    private final String projectKey;
    private final String repoSlug;
    @ElementBy(className="hero-image")
    private PageElement heroImage;
    @ElementBy(cssSelector="#webhooks-container .aui-button.action-button, #webhooks-container .aui-button-primary")
    private PageElement createWebhookButton;
    @ElementBy(cssSelector="#webhooks-container tbody")
    private PageElement webhooksTable;

    public WebhookPage(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public void delete(WebhookRow webhook) {
        webhook.delete();
        PageElement confirmDelete = this.elementFinder.find(By.cssSelector((String)"#are-you-sure-dialog .confirm-button"));
        Poller.waitUntilTrue((TimedQuery)confirmDelete.timed().isPresent());
        confirmDelete.click();
    }

    public String getUrl() {
        return String.format("/plugins/servlet/webhooks/projects/%s/repos/%s/", this.projectKey, this.repoSlug);
    }

    @WaitUntil
    public void waitFor() {
        Poller.waitUntilTrue((String)"The page has loaded all javascript and mounted components", (TimedQuery)this.elementFinder.find(By.cssSelector((String)"#webhooks-container > div")).timed().isVisible());
    }

    public boolean isEmptyState() {
        return this.heroImage.isPresent() && this.heroImage.isVisible();
    }

    public WebhookCreatePage createWebhook() {
        this.createWebhookButton.click();
        return (WebhookCreatePage)this.pageBinder.bind(WebhookCreatePage.class, new Object[]{this.projectKey, this.repoSlug});
    }

    public List<WebhookRow> getWebhooks() {
        return this.webhooksTable.findAll(By.tagName((String)"tr")).stream().map(tr -> (WebhookRow)this.pageBinder.bind(WebhookRow.class, new Object[]{tr})).collect(Collectors.toList());
    }

    public void loadMoreWebhooks() {
        this.scrollBody(this.getBodyHeight());
    }

    public boolean isLastPage() {
        PageElement tableFooter = this.elementFinder.find(By.className((String)"paged-table-message"));
        return (Boolean)tableFooter.timed().isPresent().byDefaultTimeout() != false && "No more webhooks".equals(tableFooter.getText());
    }
}

