/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.accesstokens;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.accesstokens.EditAccessTokenDialog;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public abstract class AbstractAccessTokensPage
extends BitbucketPage {
    public AccessTokenRow getLatestAccessToken() {
        return (AccessTokenRow)this.pageBinder.bind(AccessTokenRow.class, new Object[]{this.elementFinder.find(By.cssSelector((String)".access-tokens table tbody tr:first-child")), this});
    }

    public int getTokenCount() {
        if (this.elementFinder.find(By.className((String)"access-tokens-empty-state")).isVisible()) {
            return 0;
        }
        return this.elementFinder.findAll(By.cssSelector((String)".access-tokens table tbody tr")).size();
    }

    public boolean hasToken(String tokenName) {
        return this.elementFinder.findAll(By.cssSelector((String)".access-tokens table tbody tr")).stream().map(container -> new AccessTokenRow((PageElement)container, this)).anyMatch(row -> tokenName.equals(row.getName()));
    }

    public abstract AbstractAccessTokensPage rebind();

    public static class AccessTokenRow
    extends AbstractElementPageObject {
        private final AbstractAccessTokensPage parentPage;

        public AccessTokenRow(@Nonnull PageElement container, AbstractAccessTokensPage parentPage) {
            super(container);
            this.parentPage = parentPage;
        }

        public String getCreatedDate() {
            return this.container.find(By.cssSelector((String)".created-date")).getText();
        }

        public String getLastAuthenticated() {
            return this.container.find(By.cssSelector((String)".last-authenticated")).getText();
        }

        public String getName() {
            return this.container.find(By.cssSelector((String)".token-label")).getText();
        }

        public String getProjectPermissions() {
            return this.container.find(By.cssSelector((String)".project-permission")).getText();
        }

        public String getRepositoryPermissions() {
            return this.container.find(By.cssSelector((String)".repo-permission")).getText();
        }

        public EditAccessTokenDialog openEditDialog() {
            this.container.find(By.cssSelector((String)".actions .edit")).click();
            return (EditAccessTokenDialog)((Object)this.pageBinder.bind(EditAccessTokenDialog.class, new Object[]{By.className((String)"access-token-edit-dialog"), this.parentPage}));
        }

        public Dialog2 openRevokeDialog() {
            this.container.find(By.cssSelector((String)".actions .revoke")).click();
            Dialog2 dialog = (Dialog2)((Object)this.pageBinder.bind(Dialog2.class, new Object[]{By.className((String)"access-token-revoke-dialog")}));
            Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
            return dialog;
        }

        public AbstractAccessTokensPage revoke() {
            Dialog2 dialog = this.openRevokeDialog();
            PageElement revokeButton = dialog.find(By.cssSelector((String)".revoke"));
            revokeButton.click();
            Poller.waitUntilFalse((TimedQuery)dialog.isOpen());
            return this.parentPage.rebind();
        }

        public boolean hasRevokeLink() {
            return !this.container.findAll(By.cssSelector((String)".actions .revoke")).isEmpty();
        }

        public boolean hasEditLink() {
            return !this.container.findAll(By.cssSelector((String)".actions .edit")).isEmpty();
        }
    }
}

