/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Comment;
import com.atlassian.webdriver.bitbucket.element.CommitSelector;
import com.atlassian.webdriver.bitbucket.element.DiffCommentForm;
import com.atlassian.webdriver.bitbucket.element.DiffFileContent;
import com.atlassian.webdriver.bitbucket.element.DiffSelectionDropdown;
import com.atlassian.webdriver.bitbucket.element.FileTree;
import com.atlassian.webdriver.bitbucket.element.SideBySideDiffFileContent;
import com.atlassian.webdriver.bitbucket.element.UnifiedDiffFileContent;
import com.atlassian.webdriver.bitbucket.element.codeinsights.CodeInsightsDiffAnnotation;
import com.atlassian.webdriver.bitbucket.page.PullRequestPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;

public abstract class PullRequestDiffPage
extends PullRequestPage<PullRequestDiffPage> {
    @ElementBy(className="commit-selector-button")
    protected PageElement commitSelectorButton;
    @ElementBy(id="diff-options-dropdown-trigger")
    protected PageElement dropdown;
    @ElementBy(cssSelector=".file-content", pageElementClass=SideBySideDiffFileContent.class)
    protected SideBySideDiffFileContent sideBySideDiffFileContent;
    @ElementBy(cssSelector=".file-content", pageElementClass=UnifiedDiffFileContent.class)
    protected UnifiedDiffFileContent fileContent;
    @ElementBy(className="file-tree-container", pageElementClass=FileTree.class)
    private FileTree tree;
    private final String path;
    private final String projectKey;
    private final long pullRequestId;
    private String queryParams = "";
    private final String slug;

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId) {
        this(projectKey, slug, pullRequestId, null);
    }

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId, String path) {
        super(projectKey, slug, pullRequestId);
        this.projectKey = projectKey;
        this.slug = slug;
        this.pullRequestId = pullRequestId;
        this.path = path;
    }

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId, long commentId, String action) {
        this(projectKey, slug, pullRequestId);
        this.queryParams = UrlUtils.buildQueryParams((Object[])new Object[]{"commentId", commentId, "action", action});
    }

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId, String path, Integer annotationLineNumber) {
        this(projectKey, slug, pullRequestId, path);
        if (annotationLineNumber != null) {
            this.queryParams = "T" + annotationLineNumber;
        }
    }

    public void addComment(DiffFileContent.Line line, String comment) {
        DiffCommentForm element = this.openNewComment(line, comment);
        element.submit();
    }

    public <T extends Comment> T addComment(Class<T> clazz, DiffFileContent.Line line, String comment) {
        DiffCommentForm element = this.openNewComment(line, comment);
        Comment commentElement = element.submit();
        return (T)((Object)((Comment)((Object)this.pageBinder.bind(clazz, new Object[]{By.cssSelector((String)(".comment[data-id=\"" + commentElement.getId() + "\"]"))}))));
    }

    public void clickFileAndWaitUntilLoaded(String path) {
        this.waitUntilDiffTreeLoaded();
        this.tree.find(By.cssSelector((String)("[href=\"#" + path + "\"]"))).click();
        this.waitUntilFileContentLoaded();
    }

    public Comment getCommentAt(int index) {
        return this.getUnifiedFileContent().getComments().get(index);
    }

    public Optional<CodeInsightsDiffAnnotation> getAnnotationOnLine(int lineNumber) {
        return this.elementFinder.findAll(By.cssSelector((String)".added.line,.modified.line")).stream().filter(line -> this.getToLineNumber((PageElement)line).map(i -> i == lineNumber).orElse(false)).findFirst().map(line -> line.find(By.className((String)"annotation"))).map(annotation -> (CodeInsightsDiffAnnotation)this.pageBinder.bind(CodeInsightsDiffAnnotation.class, new Object[]{lineNumber, annotation}));
    }

    public List<CodeInsightsDiffAnnotation> getFileLevelAnnotations() {
        return this.elementFinder.findAll(By.className((String)"file-annotations-container")).stream().flatMap(container -> container.findAll(By.className((String)"annotation")).stream()).map(annotation -> (CodeInsightsDiffAnnotation)this.pageBinder.bind(CodeInsightsDiffAnnotation.class, new Object[]{annotation})).collect(Collectors.toList());
    }

    public List<CodeInsightsDiffAnnotation> getAllAnnotations() {
        String xpathIsAnnotation = "[contains(concat(' ', @class, ' '), ' annotation ')]";
        String xpathIsLine = "[contains(concat(' ', @class, ' '), ' line ')]";
        String xpathIsLineWithAnnotations = "//div" + xpathIsAnnotation + "/ancestor::*" + xpathIsLine;
        return Stream.concat(this.getFileLevelAnnotations().stream(), this.elementFinder.findAll(By.xpath((String)xpathIsLineWithAnnotations), TimeoutType.SLOW_PAGE_LOAD).stream().flatMap(line -> {
            Integer lineNumber = this.getToLineNumber((PageElement)line).get();
            return line.findAll(By.className((String)"annotation")).stream().map(annotation -> (CodeInsightsDiffAnnotation)this.pageBinder.bind(CodeInsightsDiffAnnotation.class, new Object[]{lineNumber, annotation}));
        })).collect(Collectors.toList());
    }

    public TimedCondition hasAnnotations() {
        return this.elementFinder.find(By.className((String)"annotation")).timed().isVisible();
    }

    public String getCommitSelectorTitle() {
        return this.commitSelectorButton.getText();
    }

    public SideBySideDiffFileContent getSideBySideFileContent() {
        return this.sideBySideDiffFileContent;
    }

    public UnifiedDiffFileContent getUnifiedFileContent() {
        return this.fileContent;
    }

    public FileTree getFileTree() {
        return this.tree;
    }

    @Override
    public String getUrl() {
        String url = super.getUrl() + this.getDiffUrl();
        String queryString = Arrays.asList(this.queryParams, this.getExtraQueryParams()).stream().filter(StringUtils::isNotBlank).collect(Collectors.joining("&"));
        if (this.getPath() != null) {
            url = url + "#" + this.getPath();
        }
        if (queryString != null && queryString.length() > 0) {
            url = url + "?" + queryString;
        }
        return url;
    }

    public void closeCommitSelector() {
        if (this.commitSelectorButton.hasClass("active")) {
            this.commitSelectorButton.click();
        }
        Poller.waitUntilFalse((TimedQuery)this.commitSelectorButton.timed().hasClass("active"));
    }

    public CommitSelector openCommitSelector() {
        if (!this.commitSelectorButton.hasClass("active")) {
            this.commitSelectorButton.click();
        }
        Poller.waitUntilTrue((TimedQuery)this.commitSelectorButton.timed().hasClass("active"));
        PageElement commitSelector = this.body.find(By.id((String)"inline-dialog-commit-selector"));
        Poller.waitUntilTrue((TimedQuery)commitSelector.find(By.className((String)"commit-list")).timed().isVisible());
        return (CommitSelector)this.pageBinder.bind(CommitSelector.class, new Object[]{commitSelector});
    }

    public DiffSelectionDropdown openDropdownSelector() {
        return ((DiffSelectionDropdown)this.pageBinder.bind(DiffSelectionDropdown.class, new Object[]{this.dropdown})).open();
    }

    public DiffCommentForm openNewComment(DiffFileContent.Line line, String comment) {
        line.getAddComment().click();
        DiffCommentForm element = (DiffCommentForm)this.tree.find(By.className((String)"new-comment-form"), DiffCommentForm.class, TimeoutType.COMPONENT_LOAD);
        element.setText(comment);
        return element;
    }

    @Override
    public int getBodyHeight() {
        return ElementUtils.getScrollInfo(this.body).getScrollHeight();
    }

    @Override
    public void scrollBody(int scrollTop) {
        ElementUtils.scrollDocument(this.body, scrollTop);
    }

    public <T> Map<FileTree.Node, T> visitEachFile(Function<FileTree.Node, T> eachFile) {
        return this.getFileTree().visitEachFile(eachFile);
    }

    public abstract PullRequestDiffPage toggleOverview();

    @Override
    @WaitUntil
    public void waitUntilPageLoaded() {
        this.waitUntilDiffTreeLoaded();
        this.waitUntilFileContentLoaded();
    }

    protected abstract String getDiffUrl();

    protected abstract String getExtraQueryParams();

    protected String getPath() {
        return this.path;
    }

    private Optional<Integer> getToLineNumber(PageElement line) {
        List toLine = line.findAll(By.className((String)"line-number-to"));
        if (toLine.isEmpty()) {
            return Optional.empty();
        }
        String text = ((PageElement)toLine.get(0)).getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return Optional.empty();
        }
        return Optional.of(Integer.valueOf(text));
    }

    private void waitUntilDiffTreeLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)".file-tree ul"), TimeoutType.PAGE_LOAD).timed().isPresent());
    }

    private void waitUntilFileContentLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#commit-file-content .fully-loaded,#commit-file-content .message-content,#commit-file-content .binary-container"), TimeoutType.PAGE_LOAD).timed().isPresent());
    }
}

